% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinController.R
\name{topoSortTables}
\alias{topoSortTables}
\title{Topologically sort join plan so values are available before uses.}
\usage{
topoSortTables(columnJoinPlan, leftTableName, ...)
}
\arguments{
\item{columnJoinPlan}{join plan}

\item{leftTableName}{which table is left}

\item{...}{force later arguments to bind by name}
}
\value{
list with dependencyGraph and sorted columnJoinPlan
}
\description{
Depends on \code{igraph} package.
Please see \code{vignette('DependencySorting', package = 'replyr')} and \code{vignette('joinController', package= 'replyr')} for more details.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE) &&
  requireNamespace("dbplyr", quietly = TRUE)) {
  # note: employeeanddate is likely built as a cross-product
  #       join of an employee table and set of dates of interest
  #       before getting to the join controller step.  We call
  #       such a table "row control" or "experimental design."
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  RSQLite::initExtension(my_db)
  tDesc <- replyr:::example_employeeAndDate(my_db)
  columnJoinPlan <- buildJoinPlan(tDesc, check= FALSE)
  # unify keys
  columnJoinPlan$resultColumn[columnJoinPlan$resultColumn=='id'] <- 'eid'
  # look at plan defects
  print(paste('problems:',
              inspectDescrAndJoinPlan(tDesc, columnJoinPlan)))
  # fix plan
  if(requireNamespace('igraph', quietly = TRUE)) {
    sorted <- topoSortTables(columnJoinPlan, 'employeeanddate')
    print(paste('problems:',
                inspectDescrAndJoinPlan(tDesc, sorted$columnJoinPlan)))
    # plot(sorted$dependencyGraph)
  }
  DBI::dbDisconnect(my_db)
  my_db <- NULL
}

}
