% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinController.R
\name{renderJoinDiagram}
\alias{renderJoinDiagram}
\title{Render a diagram spec from \code{\link{makeJoinDiagramSpec}} as a PNG graphics item.}
\usage{
renderJoinDiagram(diagramSpec, ..., pngFileName = NULL, tempDir = tempdir())
}
\arguments{
\item{diagramSpec}{diagram specification from \code{\link{makeJoinDiagramSpec}}.}

\item{...}{force later arguments to bind by name.}

\item{pngFileName}{character, if not null where to write PNG}

\item{tempDir}{character, if not null tempDir to create/use}
}
\value{
DiagrammeR::grViz result as a PNG
}
\description{
Requires packages \code{DiagrammeR} properly installed to use.
Please see \code{vignette('DependencySorting', package = 'replyr')} and \code{vignette('joinController', package= 'replyr')} for more details.
}
\details{
This PNG can be smaller than directly including a grViz rendering in markdown.
Requires all of \code{DiagrammeR}, \code{htmlwidgets}, \code{webshot}, and \code{magick} to be installed with all external dependencies properly installed and configured.
}
\seealso{
\code{\link{tableDescription}}, \code{\link{buildJoinPlan}}, \code{\link{makeJoinDiagramSpec}}, \code{\link{executeLeftJoinPlan}}
}
