% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkRank.R
\name{replyr_check_ranks}
\alias{replyr_check_ranks}
\title{confirm data has good ranked groups}
\usage{
replyr_check_ranks(x, GroupColumnName, ValueColumnName, RankColumnName,
  ..., decreasing = FALSE,
  tempNameGenerator = mk_tmp_name_source("replyr_check_ranks"))
}
\arguments{
\item{x}{data item to work with}

\item{GroupColumnName}{column to group by}

\item{ValueColumnName}{column determining order}

\item{RankColumnName}{column having proposed rank (function of order)}

\item{...}{force later arguments to bind by name}

\item{decreasing}{if true make order decreasing instead of increasing.}

\item{tempNameGenerator}{temp name generator produced by wrapr::mk_tmp_name_source, used to record dplyr::compute() effects.}
}
\value{
summary of quality of ranking.
}
\description{
confirm data has good ranked groups
}
\examples{

d <- data.frame(Sepal_Length=c(5.8,5.7),Sepal_Width=c(4.0,4.4),
                Species='setosa',rank=c(1,2))
replyr_check_ranks(d,'Species','Sepal_Length','rank',  decreasing=TRUE)

}
