\name{petsum}
\alias{petsum}
\title{Print LaTeX event time summary}
\usage{
  petsum(data, response, group = 1, times = c(12, 14),
    units = "months")
}
\arguments{
  \item{data}{dataframe containing data}

  \item{response}{character vector with names of columns to
  use for response}

  \item{group}{string specifiying the column name of
  stratification variable}

  \item{times}{numeric vector of times you want survival
  time provbabilities for.}

  \item{units}{string indicating the unit of time. Use
  lower case and plural.}
}
\description{
  Wrapper for the etsum function that prints paragraphs of
  text in LaTeX
}
\examples{
require(survival)
lung$sex<-factor(lung$sex)
petsum(lung,c("time","status"),"sex")
petsum(lung,c("time","status"))
petsum(lung,c("time","status"),"sex",c(1,2,3),"months")
}
\keyword{print}

