% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_spec.R
\name{write_registration_file}
\alias{write_registration_file}
\title{Create a registration file}
\usage{
write_registration_file(file_path)
}
\arguments{
\item{file_path}{The full or relative file name and path to create the 
registration file.}
}
\description{
This function will create a registration file to help determine
the correct \code{cpuom} and \code{lpuom} for your editor/printer.
}
\details{
The \code{cpi} and \code{lpi} are 
used in \code{output_type = "TXT"} to determine available space on
the page. The registration file can help determine the correct settings
for the target text editor and printer.  Failure to set the 
correct characters per 
unit of measure (cpuom) and lines per unit of measure (lpuom) may result
in misalignment of content on the page when printing text output.
}
\section{How to Use the Registration File}{

To use the registration file, first decide the units of measure you
wish to use, inches or centimeters.  Next, create the registration file
by calling the \code{write_registration_file} function.  Then print the 
registration file.

Once the registration file is printed, take a ruler and measure both the 
horizontal and vertical registration lines from zero to 60 in the desired
units of measure.  For example, if your units of measure is 'inches', measure
the registration lines in inches.    

Record the 
distance measured in each direction.  For each direction, divide 60 by the 
distance measured, and round to three decimal places.  The horizontal 
result is the characters per unit of measure (cpuom).  The vertical result
is the lines per unit of measure (lpuom). To get an accurate printing 
of text reports, 
assign these values to the \code{cpuom} and \code{lpuom} parameters
on the \code{\link{options_fixed}} function.

For best results, test the calculated values by printing some reports and
checking for undesired page breaks or wrapped lines.  If necessary, adjust
the calculated cpuom and lpuom values until all content stays within 
the available space without wrapping or breaking.
}

\examples{
library(reporter)

# Create temp file path
tmp <- file.path(tempdir(), "reg.txt")

# Create the registration file 
write_registration_file(tmp)

# Write registration file to the console
writeLines(readLines(tmp))

# 0--------+---------+---------+---------+---------+---------+
# -       10        20        30        40        50        60
# -
# -
# -
# -
# -
# -
# -
# + 10
# -
# -
# -
# -
# -
# -
# -
# -
# -
# + 20
# -
# -
# -
# -
# -
# -
# -
# -
# -
# + 30
# -
# -
# -
# -
# -
# -
# -
# -
# -
# + 40
# -
# -
# -
# -
# -
# -
# -
# -
# -
# + 50
# -
# -
# -
# -
# -
# -
# -
# -
# -
# + 60
}
