% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_spec.r
\name{footnotes}
\alias{footnotes}
\title{Adds a footnote block}
\usage{
footnotes(
  x,
  ...,
  align = "left",
  blank_row = "above",
  borders = "none",
  valign = NULL,
  width = NULL
)
}
\arguments{
\item{x}{The object to assign footnotes to.}

\item{...}{A set of footnote strings.}

\item{align}{The position to align the footnotes.  Valid values are: 'left',
'right', 'center', or 'centre'.}

\item{blank_row}{Whether to print a blank row above or below the footnote.
Valid values are 'above', 'below', 'both', or 'none'.  Default is 'above'.}

\item{borders}{Whether to print a border above or below the footnote. Valid
values are 'top', 'bottom', 'outside', 'inside', 'all',  or 'none'.  
Default is 'none'.  
For fixed width reports, the 
border character will be taken from the value of the \code{uchar} parameter
on the \code{\link{options_fixed}} function.  The 
'left', 'right', 'outside', and 'inside' border specifications only apply 
to RTF reports.}

\item{valign}{The vertical position to align the footnotes.  Valid
values are: 'top' and 'bottom'.  For footnotes attached to a report,
default is 'bottom'.  For footnotes attached to content, default is 'top'.}

\item{width}{The width of the footnotes block.  If the footnotes are attached
to the report, valid values are 'page' or a numeric width, and the default
is 'page'. If the footnotes are attached to the
table, plot, or text content, the valid values are 'page', 'content' or a 
numeric value, and the default is 'content'.  The value 'content' means the 
footnotes will be aligned to the width of the table, plot, or text
content.  The value
'page' means the footnotes will be aligned to the width of the page. 
In addition to these two convenience settings, you 
may also specify a specific width in the current unit of measure.  The
unit of measure is determined by the 'units' parameter on 
\code{\link{create_report}}.}
}
\value{
The modified report.
}
\description{
The \code{footnotes} function adds one or more footnotes to the report.  
If added to the report specification, the footnotes will
be added to the page template, and thus appear on each page of the report.
Footnotes may also be added directly to table, text, or plot content.
}
\details{
The \code{footnotes} function accepts a set of strings of the desired 
footnote text. The footnotes may be aligned center, left or right using 
the align parameter. The user is responsible for adding desired footnote 
symbols. Footnote symbols will not be generated automatically.

If footnotes are assigned to the report,
alignment will be oriented to the page body.  If footnotes are assigned to
a table or text, alignment will be oriented to the edge of the content.

One footnote function accepts up to 25 footnotes.  However, multiple footnote 
blocks may be added to the same object.  

Blank rows above or below the footnote block may be controlled using the 
\code{blank_row} parameter.

Each footnote string must fit within the available space.  The \strong{reporter}
package will not wrap footnotes on fixed-width reports.  
If a footnote does not fit within the 
available space, a warning will be generated and the footnote will be 
truncated.  In these situations, either
shorten the footnote or split it into multiple footnotes that each fit within 
the available space.
}
\examples{
library(reporter)
library(magrittr)

# Create a temporary file
tmp <- file.path(tempdir(), "expenses.txt")

# Prepare data
dat <- data.frame(category = rownames(USPersonalExpenditure),
                  USPersonalExpenditure, stringsAsFactors = FALSE)

# Define table
tbl <- create_table(dat) \%>\% 
  titles("Table 1.0", "US Personal Expenditures from 1940 - 1960") \%>\% 
  column_defaults(from = X1940, to = X1960, width = .6, format = "$\%.2f") \%>\%
  define(category, label = "Category") \%>\% 
  define(X1940, label = "1940") \%>\% 
  define(X1945, label = "1945") \%>\% 
  define(X1950, label = "1950") \%>\% 
  define(X1955, label = "1955") \%>\% 
  define(X1960, label = "1960") \%>\% 
  footnotes("* In billions of dollars")

# Define report
rpt <- create_report(tmp, orientation="portrait") \%>\%
  add_content(tbl) 

# Write the report
write_report(rpt)

# Display in console
writeLines(readLines(tmp, encoding = "UTF-8"))

#                               Table 1.0
#               US Personal Expenditures from 1940 - 1960
# 
#     Category                1940    1945    1950    1955    1960
#     ------------------------------------------------------------
#     Food and Tobacco      $22.20  $44.50  $59.60  $73.20  $86.80
#     Household Operation   $10.50  $15.50  $29.00  $36.50  $46.20
#     Medical and Health     $3.53   $5.76   $9.71  $14.00  $21.10
#     Personal Care          $1.04   $1.98   $2.45   $3.40   $5.40
#     Private Education      $0.34   $0.97   $1.80   $2.60   $3.64
# 
#     * In billions of dollars
}
\seealso{
Other report: 
\code{\link{add_content}()},
\code{\link{create_report}()},
\code{\link{options_fixed}()},
\code{\link{page_by}()},
\code{\link{page_footer}()},
\code{\link{page_header}()},
\code{\link{print.report_spec}()},
\code{\link{set_margins}()},
\code{\link{title_header}()},
\code{\link{titles}()},
\code{\link{write_report}()}
}
\concept{report}
