% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\name{updateFilenameSlots}
\alias{updateFilenameSlots}
\alias{updateFilenameSlots.default}
\alias{updateFilenameSlots.list}
\alias{updateFilenameSlots.environment}
\alias{updateFilenameSlots.Raster}
\title{A helper function to change the filename slot of \code{Raster*} objects}
\usage{
updateFilenameSlots(obj, curFilenames, newFilenames, isStack = NULL)

\method{updateFilenameSlots}{default}(obj, ...)

\method{updateFilenameSlots}{list}(obj, ...)

\method{updateFilenameSlots}{environment}(obj, ...)

\method{updateFilenameSlots}{Raster}(obj, curFilenames, newFilenames, isStack = NULL)
}
\arguments{
\item{obj}{An object. This function only has useful methods for \code{Raster*},
with all other classes being simply a pass-through}

\item{curFilenames}{An optional character vector of filenames currently existing
and that are pointed to in the obj. If omitted, will take from the \code{obj}
using \code{Filenames(obj)}}

\item{newFilenames}{An optional character vector of filenames to use instead of
the curFilenames. This can also be a single directory, in which case the
renaming will be given:
\code{file.path(newFilenames, basename(Filenames(obj, allowMultiple = FALSE)))}}
}
\description{
This is intended for internal use, though it is exported because other packages
use this. This function exists because when copying file-backed rasters, the
usual mechanism of \code{writeRaster} can be very slow. This function allows
for a user to optionally create a hard link to the old file, give it a new
name, then update the filename slot(s) in the \code{Raster*} class object. This
can be 100s of times faster for large rasters.
}
\keyword{internal}
