% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sry_storage.R
\name{storage}
\alias{storage}
\title{Storage-Reliability-Yield (SRY) relationships: Storage computation}
\usage{
storage(Q, yield, reliability, demand_profile, plot = TRUE, S_initial = 1,
  max_iterations = 50, double_cycle = FALSE)
}
\arguments{
\item{Q}{vector or time series object. Net inflow totals to the reservoir. Recommended units: Mm^3 (Million cubic meters).}

\item{yield}{the required yield. Must be same volumetric units as Q.}

\item{reliability}{numerical. The required time-based reliability.}

\item{demand_profile}{a vector of factors with length = frequency(Q). Represents within-year demand profile. Defaults to constant release if left blank.}

\item{plot}{logical. If TRUE (the default) the storage behavior diagram and release time series are plotted.}

\item{S_initial}{numeric. The initial storage as a ratio of capacity (0 <= S_initial <= 1). The default value is 1.}

\item{max_iterations}{Maximum number of iterations for yield computation.}

\item{double_cycle}{logical. If TRUE the input series will be replicated and placed end-to-end to double the simulation. (Recommended if the critical period occurs at the end of the recorded inflow time series)}
}
\value{
Returns the required storage capacity necessary to supply specified yield with specified reliability.
}
\description{
Returns the required storage for given inflow time series, yield, and target time-based reliability. Assumes standard operating policy. Storage is computed iteratively using the bi-section method.
}
\examples{
# Determine the required storage for 95 \% reliability and yield equal to 80 \% of the mean inflow.
layout(1:3)
storage(resX$Q_Mm3 * 20, yield = 0.9 * mean(resX$Q_Mm3), reliability = 0.95)
}

