% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto.R
\name{Pareto}
\alias{Pareto}
\alias{rpareto}
\alias{dpareto}
\alias{ppareto}
\alias{qpareto}
\title{The Pareto Distribution}
\usage{
rpareto(n = 1L, shape = 0, scale = 1)

dpareto(x, shape = 1, scale = 1, log = FALSE)

ppareto(q, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

qpareto(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{n}{integer number of observations.}

\item{shape}{shape parameter (must be positive).}

\item{scale}{scale parameter (must be positive).}

\item{x, q}{vector of quantiles.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/densities
\code{p} are given as \code{log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are
\eqn{P(X \le x)}, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}
}
\value{
\code{rpareto} generates random deviates.

\code{dpareto} gives the density.

\code{ppareto} gives the distribution function.

\code{qpareto} gives the quantile function.
}
\description{
These functions provide information about the Pareto distribution.
\code{dpareto} gives the density, \code{ppareto} gives the distribution
function, \code{qpareto} gives the quantile function and \code{rpareto} generates random
deviates.
}
\details{
If \code{shape} or \code{scale} are not specified, they assume the default values of \code{1}.

The Pareto distribution with scale \eqn{\theta} and shape \eqn{\xi} has density

\deqn{f(x) = \xi \theta^\xi / (x + \theta)^(\xi + 1)}

The support is \eqn{x \ge 0}.

The Expected value exists if \eqn{\xi > 1} and is equal to

\deqn{E(X) = \theta / (\xi - 1)}

k-th moments exist in general for \eqn{k < \xi}.
}
\examples{

x <- rpareto(1000, shape = 10, scale = 5)
xx <- seq(-1, 10, 0.01)
hist(x, breaks = 100, freq = FALSE, xlim = c(-1, 10))
lines(xx, dpareto(xx, shape = 10, scale = 5))

plot(xx, dpareto(xx, shape = 10, scale = 5), type = "l")
lines(xx, dpareto(xx, shape = 3, scale = 5), col = "red", lwd = 2)

plot(xx, dpareto(xx, shape = 10, scale = 10), type = "l")
lines(xx, dpareto(xx, shape = 10, scale = 5), col = "blue", lwd = 2)
lines(xx, dpareto(xx, shape = 10, scale = 20), col = "red", lwd = 2)

}
\references{
\url{https://en.wikipedia.org/wiki/Pareto_distribution} - named Lomax therein.
}
