% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_mixture.R, R/distribution_generics.R
\name{fit_dist_start.MixtureDistribution}
\alias{fit_dist_start.MixtureDistribution}
\alias{fit_dist_start}
\title{Find starting values for distribution parameters}
\usage{
\method{fit_dist_start}{MixtureDistribution}(dist, obs, dists_start = NULL, ...)

fit_dist_start(dist, obs, ...)
}
\arguments{
\item{dist}{A \code{Distribution} object.}

\item{obs}{Observations to fit to.}

\item{dists_start}{List of initial parameters for all component
distributions. If left empty, initialisation will be automatically performed
using \code{\link[=fit_dist_start]{fit_dist_start()}} with all observations in the support of each
respective component.}

\item{...}{Additional arguments for the initialisation procedure}
}
\value{
A list of initial parameters suitable for passing to \code{\link[=fit_dist]{fit_dist()}}.
}
\description{
Find starting values for distribution parameters
}
\examples{
fit_dist_start(dist_exponential(), rexp(100))
}
