% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_stats.R
\name{weighted_quantile}
\alias{weighted_quantile}
\alias{weighted_median}
\title{Compute weighted quantiles}
\usage{
weighted_quantile(x, w, probs)

weighted_median(x, w)
}
\arguments{
\item{x}{Observations}

\item{w}{Case weights (optional)}

\item{probs}{Quantiles to calculate}
}
\value{
A vector the same length as \code{probs} with the corresponding weighted
quantiles of \code{x} with weight \code{w}. For integer weights, this is equivalent to
\code{quantile(rep(x, w), probs)}

The weighted median of \code{x} with weights \code{w}.
For integer weights, this is equivalent to \code{median(rep(x, w))}
}
\description{
Compute weighted quantiles
}
\examples{
weighted_median(1:6)
weighted_median(1:3, c(1, 4, 9))
weighted_median(1:3, c(9, 4, 1))

weighted_quantile(1:3, c(1, 4, 9), seq(0.0, 1.0, by = 0.25))
quantile(rep(1:3, c(1, 4, 9)), seq(0.0, 1.0, by = 0.25))
}
\seealso{
Other weighted statistics: 
\code{\link{weighted_moments}()},
\code{\link{weighted_tabulate}()}
}
\concept{weighted statistics}
