% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sardine.rd}
\alias{sardine.rd}
\title{Respirometry data of the sardine, \emph{Sardinops sagax}}
\format{
A data frame object consisting of 3 columns (time, \% air saturation
and temperature) and 7513 rows (approx 2.1h of data).
}
\usage{
sardine.rd
}
\description{
A single experiment on the sardine species \emph{Sardinops sagax} in a Loligo
Systems swim tunnel and Witrox oxygen probe system. There are three columns:
\verb{$Time} in seconds, \verb{$Oxygen} content recorded in percent air saturation, and
\verb{$Temperature} in °C. Mean temperature, salinity and atmospheric pressure are
supplied below to allow for conversion to oxygen concentration units.
}
\details{
Experiment conducted at Hopkins Marine Station, Stanford University, Pacific
Grove, California.
\itemize{
\item Dissolved oxygen units: \verb{\% air saturation}
\item Time units: \code{seconds}
\item Chamber volume (L): \code{12.3}
\item Specimen wet mass (kg): \code{0.0477}
\item Temperature (°C): \code{14.8}
\item Salinity: \code{35}
\item Atm. Pressure (bar): \code{1.013253}
}
}
\author{
Nicholas Carey
}
\keyword{datasets}
