% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-setup-tools.R
\name{demo_db_create}
\alias{demo_db_create}
\title{Create demo database}
\usage{
demo_db_create(db_type = "nucleotide", n = 100)
}
\arguments{
\item{db_type}{character, database type}

\item{n}{integer, number of mock sequences}
}
\description{
Creates a local mock SQL database
from package test data for demonstration purposes.
No internet connection required.
}
\examples{
library(restez)
# set the restez path to a temporary dir
restez_path_set(filepath = tempdir())
# create demo database
demo_db_create(n = 5)
restez_connect()
# in the demo, IDs are 'demo_1', 'demo_2' ...
(gb_sequence_get(id = 'demo_1'))

# Delete a demo database after an example
db_delete(everything = TRUE)
}
\seealso{
Other database: \code{\link{count_db_ids}},
  \code{\link{db_create}}, \code{\link{db_delete}},
  \code{\link{db_download}}, \code{\link{is_in_db}},
  \code{\link{list_db_ids}}
}
\concept{database}
