% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb-setup-tools.R
\name{gb_build}
\alias{gb_build}
\title{Read and add .seq files to database}
\usage{
gb_build(
  dpth,
  seq_files,
  max_length,
  min_length,
  acc_filter = NULL,
  invert = FALSE,
  scan = FALSE
)
}
\arguments{
\item{dpth}{Download path (where seq_files are stored)}

\item{seq_files}{.seq.tar seq file names}

\item{max_length}{Maximum sequence length, default NULL.}

\item{min_length}{Minimum sequence length, default 0.}

\item{acc_filter}{Character vector; accessions to include or exclude from
the database as specified by \code{invert}.}

\item{invert}{Logical vector of length 1; if TRUE, accessions in \code{acc_filter}
will be excluded from the database; if FALSE, only accessions in \code{acc_filter}
will be included in the database. Default FALSE.}

\item{scan}{Logical vector of length 1; should the sequence file be scanned
for accessions in \code{acc_filter} prior to processing?
Requires zgrep to be installed (so does not work on Windows).
Only used if \code{acc_filter} is not NULL and \code{invert} is FALSE. Default FALSE.}
}
\value{
Logical
}
\description{
Given a list of seq_files, read and add the contents of the
files to a SQL-like database. If any errors during the process, FALSE is
returned.
}
\details{
This function will automatically connect to the restez database.
}
\seealso{
Other private: 
\code{\link{add_rcrd_log}()},
\code{\link{cat_line}()},
\code{\link{char}()},
\code{\link{check_connection}()},
\code{\link{cleanup}()},
\code{\link{connected}()},
\code{\link{connection_get}()},
\code{\link{db_download_intern}()},
\code{\link{db_sqlngths_get}()},
\code{\link{db_sqlngths_log}()},
\code{\link{dir_size}()},
\code{\link{dwnld_path_get}()},
\code{\link{dwnld_rcrd_log}()},
\code{\link{entrez_fasta_get}()},
\code{\link{entrez_gb_get}()},
\code{\link{extract_accession}()},
\code{\link{extract_by_patterns}()},
\code{\link{extract_clean_sequence}()},
\code{\link{extract_definition}()},
\code{\link{extract_features}()},
\code{\link{extract_inforecpart}()},
\code{\link{extract_keywords}()},
\code{\link{extract_locus}()},
\code{\link{extract_organism}()},
\code{\link{extract_seqrecpart}()},
\code{\link{extract_sequence}()},
\code{\link{extract_version}()},
\code{\link{file_download}()},
\code{\link{filename_log}()},
\code{\link{flatfile_read}()},
\code{\link{gb_df_create}()},
\code{\link{gb_df_generate}()},
\code{\link{gb_sql_add}()},
\code{\link{gb_sql_query}()},
\code{\link{gbrelease_check}()},
\code{\link{gbrelease_get}()},
\code{\link{gbrelease_log}()},
\code{\link{has_data}()},
\code{\link{identify_downloadable_files}()},
\code{\link{last_add_get}()},
\code{\link{last_dwnld_get}()},
\code{\link{last_entry_get}()},
\code{\link{latest_genbank_release_notes}()},
\code{\link{latest_genbank_release}()},
\code{\link{message_missing}()},
\code{\link{mock_def}()},
\code{\link{mock_gb_df_generate}()},
\code{\link{mock_org}()},
\code{\link{mock_rec}()},
\code{\link{mock_seq}()},
\code{\link{predict_datasizes}()},
\code{\link{readme_log}()},
\code{\link{restez_connect}()},
\code{\link{restez_disconnect}()},
\code{\link{restez_path_check}()},
\code{\link{restez_rl}()},
\code{\link{search_gz}()},
\code{\link{seshinfo_log}()},
\code{\link{setup}()},
\code{\link{slctn_get}()},
\code{\link{slctn_log}()},
\code{\link{sql_path_get}()},
\code{\link{status_class}()},
\code{\link{stat}()},
\code{\link{testdatadir_get}()}
}
\concept{private}
