% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb-get-tools.R
\name{gb_record_get}
\alias{gb_record_get}
\title{Get record from GenBank}
\usage{
gb_record_get(id)
}
\arguments{
\item{id}{character, sequence accession ID(s)}
}
\value{
named vector of records, if no results found NULL
}
\description{
Return the entire GenBank record for an accession ID.
Equivalent to \code{rettype='gb'} in \code{\link[rentrez:entrez_fetch]{rentrez::entrez_fetch()}}.
}
\examples{
library(restez)
restez_path_set(filepath = tempdir())
demo_db_create(n = 5)
(rec <- gb_record_get(id = 'demo_1'))
(recs <- gb_record_get(id = c('demo_1', 'demo_2')))


# delete demo after example
db_delete(everything = TRUE)
}
\seealso{
\code{\link[=ncbi_acc_get]{ncbi_acc_get()}}

Other get: 
\code{\link{gb_definition_get}()},
\code{\link{gb_fasta_get}()},
\code{\link{gb_organism_get}()},
\code{\link{gb_sequence_get}()},
\code{\link{gb_version_get}()}
}
\concept{get}
