% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-setup-tools.R
\name{ncbi_acc_get}
\alias{ncbi_acc_get}
\title{Get accession numbers by querying NCBI GenBank}
\usage{
ncbi_acc_get(query, strict = TRUE, drop_ver = TRUE)
}
\arguments{
\item{query}{Character vector of length 1; query string to search GenBank.}

\item{strict}{Logical vector of length 1; should an error be issued if
the number of unique accessions retrieved does not match the number of hits
from GenBank? Default TRUE.}

\item{drop_ver}{Logical vector of length 1; should the version part of the
accession number (e.g., '.1' in 'AB001538.1') be dropped? Default TRUE.}
}
\value{
Character vector; accession numbers resulting from query.
}
\description{
The query string can be formatted using
\href{https://www.ncbi.nlm.nih.gov/nuccore/advanced}{GenBank advanced query terms}
to obtain accession numbers corresponding to a specific set of criteria.
}
\details{
Note this queries NCBI GenBank, not the local database generated with restez.

It can be used either to restrict the accessions used to construct the local
database (\code{acc_filter} argument of \code{\link[=db_create]{db_create()}}) or to specify accessions
to read from the local database (\code{id} argument of \code{\link[=gb_fasta_get]{gb_fasta_get()}} and other
gb_*_get() functions).
}
\examples{
\dontrun{
  # requires an internet connection
  cmin_accs <- ncbi_acc_get("Crepidomanes minutum")
  length(cmin_accs)
  head(cmin_accs)
}
}
\seealso{
\code{\link[=db_create]{db_create()}}, \code{\link[=gb_fasta_get]{gb_fasta_get()}}
}
