/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.element;

import java.util.Random;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropElementV_fast
extends Propagator<IntVar> {
    private final IntVar var;
    private final IntVar index;
    private final int offset;
    private boolean fast;
    private final Random rd;
    private int calls;
    private int success;
    private boolean rem;

    public PropElementV_fast(IntVar value, IntVar[] values, IntVar index, int offset) {
        super((Variable[])ArrayUtils.append({value, index}, values), (Priority)PropagatorPriority.LINEAR, false);
        this.var = ((IntVar[])this.vars)[0];
        this.index = ((IntVar[])this.vars)[1];
        this.offset = offset;
        this.fast = true;
        this.rd = new Random(((IntVar[])this.vars)[0].getModel().getSeed());
        this.success = 1;
        this.calls = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(int evtmask) throws ContradictionException {
        double p = (double)this.success * 1.0 / ((double)this.calls * 1.0);
        this.fast = (double)this.rd.nextFloat() < p;
        this.rem = false;
        try {
            this.filter();
        }
        finally {
            ++this.calls;
            if (this.rem) {
                ++this.success;
            }
        }
    }

    private void filter() throws ContradictionException {
        IntVar v;
        boolean filter;
        do {
            filter = this.index.updateBounds(this.offset, ((IntVar[])this.vars).length + this.offset - 3, this);
            int lb = this.index.getLB();
            int ub = this.index.getUB();
            int min = 0x3FFFFFFF;
            int max = -1073741824;
            int i = lb;
            while (i <= ub) {
                if (this.disjoint(this.var, ((IntVar[])this.vars)[2 + i - this.offset])) {
                    filter |= this.index.removeValue(i, this);
                }
                min = Math.min(min, ((IntVar[])this.vars)[2 + i - this.offset].getLB());
                max = Math.max(max, ((IntVar[])this.vars)[2 + i - this.offset].getUB());
                i = this.index.nextValue(i);
            }
            if (!this.index.hasEnumeratedDomain() && this.index.getUB() < ub) {
                i = ub - 1;
                while (i >= lb && this.disjoint(this.var, ((IntVar[])this.vars)[2 + i - this.offset])) {
                    filter |= this.index.removeValue(i, this);
                    i = this.index.previousValue(i);
                }
            }
            filter |= this.var.updateBounds(min, max, this);
            if (!this.index.isInstantiated()) continue;
            filter |= this.propagateEquality(this.var, ((IntVar[])this.vars)[2 + this.index.getValue() - this.offset]);
        } while (filter);
        if (this.var.isInstantiated() && this.index.isInstantiated() && (v = ((IntVar[])this.vars)[2 + this.index.getValue() - this.offset]).isInstantiated() && v.getValue() == this.var.getValue()) {
            this.setPassive();
        }
    }

    private boolean propagateEquality(IntVar a2, IntVar b) throws ContradictionException {
        int s = a2.getDomainSize() + b.getDomainSize();
        boolean filter = a2.updateBounds(b.getLB(), b.getUB(), this);
        filter |= b.updateBounds(a2.getLB(), a2.getUB(), this);
        if (!this.fast) {
            this.rem |= this.filterFrom(a2, b);
            this.rem |= this.filterFrom(b, a2);
        }
        if (a2.getDomainSize() + b.getDomainSize() != s) {
            filter |= this.propagateEquality(a2, b);
        }
        return filter;
    }

    private boolean filterFrom(IntVar a2, IntVar b) throws ContradictionException {
        boolean filter = false;
        if (a2.getDomainSize() != b.getDomainSize()) {
            int lb = a2.getLB();
            int ub = a2.getUB();
            int i = lb;
            while (i <= ub) {
                if (!b.contains(i)) {
                    filter |= a2.removeValue(i, this);
                }
                i = a2.nextValue(i);
            }
        }
        return filter;
    }

    private boolean disjoint(IntVar a2, IntVar b) {
        int ua;
        int lb;
        int ub;
        int la = a2.getLB();
        if (la > (ub = b.getUB()) || (lb = b.getLB()) > (ua = a2.getUB())) {
            return true;
        }
        if (this.fast) {
            return false;
        }
        if (a2.getDomainSize() <= b.getDomainSize() ? this.intersect(a2, la, ua, b, lb, ub) : this.intersect(b, lb, ub, a2, la, ua)) {
            return false;
        }
        this.rem = true;
        return true;
    }

    private boolean intersect(IntVar v1, int l1, int u1, IntVar v2, int l2, int u2) {
        int low = Math.max(l1, l2);
        int upp = Math.min(u1, u2);
        int i = v1.nextValue(low - 1);
        while (i <= upp) {
            if (v2.contains(i)) {
                return true;
            }
            i = v1.nextValue(i);
        }
        return false;
    }

    @Override
    public ESat isEntailed() {
        int lb = this.index.getLB();
        int ub = this.index.getUB();
        int min = 0x3FFFFFFF;
        int max = -1073741824;
        int val = this.var.getLB();
        boolean exists = false;
        int i = lb;
        while (i <= ub) {
            int j = 2 + i - this.offset;
            if (j >= 2 && j < ((IntVar[])this.vars).length) {
                min = Math.min(min, ((IntVar[])this.vars)[j].getLB());
                max = Math.max(max, ((IntVar[])this.vars)[j].getUB());
                exists |= ((IntVar[])this.vars)[j].contains(val);
            }
            i = this.index.nextValue(i);
        }
        if (min > this.var.getUB() || max < this.var.getLB()) {
            return ESat.FALSE;
        }
        if (this.var.isInstantiated() && !exists) {
            return ESat.FALSE;
        }
        if (this.var.isInstantiated() && min == max) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

