/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.basic;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNbLoops
extends Propagator<Variable> {
    private final GraphVar g;
    private final IntVar k;

    public PropNbLoops(GraphVar graph, IntVar k) {
        super(new Variable[]{graph, k}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.k = k;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        int min = 0;
        int max = 0;
        ISet nodes = this.g.getPotentialNodes();
        ISetIterator iSetIterator = nodes.iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.g.getMandatorySuccessorsOf(i).contains(i)) {
                ++min;
                ++max;
                continue;
            }
            if (!this.g.getPotentialSuccessorsOf(i).contains(i)) continue;
            ++max;
        }
        this.k.updateLowerBound(min, this);
        this.k.updateUpperBound(max, this);
        if (min == max) {
            this.setPassive();
        } else if (this.k.isInstantiated()) {
            if (this.k.getValue() == max) {
                iSetIterator = nodes.iterator();
                while (iSetIterator.hasNext()) {
                    i = (Integer)iSetIterator.next();
                    if (!this.g.getPotentialSuccessorsOf(i).contains(i)) continue;
                    this.g.enforceEdge(i, i, this);
                }
                this.setPassive();
            } else if (this.k.getValue() == min) {
                iSetIterator = nodes.iterator();
                while (iSetIterator.hasNext()) {
                    i = (Integer)iSetIterator.next();
                    if (this.g.getMandatorySuccessorsOf(i).contains(i)) continue;
                    this.g.removeEdge(i, i, this);
                }
                this.setPassive();
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return GraphEventType.REMOVE_EDGE.getMask() + GraphEventType.ADD_EDGE.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        int min = 0;
        int max = 0;
        ISet env = this.g.getPotentialNodes();
        ISetIterator iSetIterator = env.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.g.getMandatorySuccessorsOf(i).contains(i)) {
                ++min;
                ++max;
                continue;
            }
            if (!this.g.getPotentialSuccessorsOf(i).contains(i)) continue;
            ++max;
        }
        if (this.k.getLB() > max || this.k.getUB() < min) {
            return ESat.FALSE;
        }
        if (min == max) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

