/*
 * Decompiled with CFR 0.152.
 */
package org.restopt;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;
import org.restopt.RestoptProblem;
import org.restopt.choco.ConnectivityFinderSpatialGraph;
import org.restopt.choco.LandscapeIndicesUtils;
import org.restopt.exception.RestoptException;
import org.restopt.objectives.AbstractRestoptObjective;
import org.restopt.objectives.EffectiveMeshSizeObjective;
import org.restopt.objectives.IntegralIndexOfConnectivityObjective;

public class RestoptSolution {
    public static final String KEY_MIN_RESTORE = "min_restore";
    public static final String KEY_TOTAL_RESTORABLE = "total_restorable";
    public static final String KEY_NB_PUS = "nb_planning_units";
    public static final String KEY_NB_COMPONENTS = "nb_components";
    public static final String KEY_DIAMETER = "diameter";
    public static final String KEY_OPTIMALITY_PROVEN = "optimality_proven";
    public static final String KEY_SEARCH_STATE = "search_state";
    public static final String KEY_SOLVING_TIME = "solving_time";
    public static final String[] KEYS = new String[]{"min_restore", "total_restorable", "nb_planning_units", "nb_components", "diameter", "optimality_proven", "search_state", "solving_time"};
    private final RestoptProblem problem;
    private final AbstractRestoptObjective objective;
    private final Solution solution;
    private final Map<String, String> characteristics;
    private Map<String, String> messages;

    public RestoptSolution(RestoptProblem problem, AbstractRestoptObjective objective, Solution solution) {
        this.problem = problem;
        this.objective = objective;
        this.solution = solution;
        this.characteristics = this.makeCharacteristics();
        this.initMessages();
    }

    public void initMessages() {
        this.messages = new HashMap<String, String>();
        this.messages.put(KEY_MIN_RESTORE, "Minimum area to restore: ");
        this.messages.put(KEY_TOTAL_RESTORABLE, "Total restorable area: ");
        this.messages.put(KEY_NB_PUS, "Number of planning units: ");
        this.messages.put(KEY_NB_COMPONENTS, "Number of connected components: ");
        this.messages.put(KEY_DIAMETER, "Diameter: ");
        this.messages.put(KEY_OPTIMALITY_PROVEN, "Optimality proven: ");
        this.messages.put(KEY_SEARCH_STATE, "Search state: ");
        this.messages.put(KEY_SOLVING_TIME, "Solving time (seconds): ");
        for (String[] s : this.objective.appendMessages()) {
            this.messages.put(s[0], s[1]);
        }
        if (this.problem.hasMeshConstraint()) {
            this.messages.put("mesh", "MESH value: ");
        }
        if (this.problem.hasIICConstraint()) {
            this.messages.put("iic", "IIC value: ");
        }
    }

    private Map<String, String> makeCharacteristics() {
        int precision;
        HashMap<String, String> solCharacteristics = new HashMap<String, String>();
        solCharacteristics.put(KEY_MIN_RESTORE, String.valueOf(this.getMinRestoreArea()));
        solCharacteristics.put(KEY_TOTAL_RESTORABLE, String.valueOf(this.getTotalRestorableArea()));
        solCharacteristics.put(KEY_NB_PUS, String.valueOf(this.getRestorationPlanningUnits().length));
        solCharacteristics.put(KEY_NB_COMPONENTS, String.valueOf(this.getNbComponents()));
        solCharacteristics.put(KEY_DIAMETER, String.valueOf(this.getDiameter()));
        solCharacteristics.put(KEY_SOLVING_TIME, String.valueOf(1.0 * (double)this.objective.getTotalRuntime() / 1000.0));
        solCharacteristics.put(KEY_SEARCH_STATE, String.valueOf(this.problem.getSearchState()));
        solCharacteristics.put(KEY_OPTIMALITY_PROVEN, String.valueOf(this.objective.isProvenOptimal()));
        solCharacteristics.putAll(this.objective.appendCharacteristics(this.solution));
        if (this.problem.hasMeshConstraint()) {
            IntVar mesh = this.problem.getMeshConstraint().getMesh();
            precision = this.problem.getMeshConstraint().getPrecision();
            solCharacteristics.put("mesh", String.valueOf(1.0 * (double)this.solution.getIntVal(mesh) / Math.pow(10.0, precision)));
        }
        if (this.problem.hasIICConstraint()) {
            IntVar iic = this.problem.getIICConstraint().getIic();
            precision = this.problem.getIICConstraint().getPrecision();
            solCharacteristics.put("iic", String.valueOf(1.0 * (double)this.solution.getIntVal(iic) / Math.pow(10.0, precision)));
        }
        return solCharacteristics;
    }

    public Map<String, String> getCharacteristics() {
        return this.characteristics;
    }

    public String getCharacteristicsAsCsv() {
        String key;
        String[][] orderedCharacteristics = new String[2][];
        String[] allKeys = ArrayUtils.append(KEYS, this.objective.getAdditionalKeys());
        if (this.problem.hasMeshConstraint() && !(this.objective instanceof EffectiveMeshSizeObjective)) {
            key = "mesh";
            allKeys = ArrayUtils.append(allKeys, {key});
        }
        if (this.problem.hasIICConstraint() && !(this.objective instanceof IntegralIndexOfConnectivityObjective)) {
            key = "iic";
            allKeys = ArrayUtils.append(allKeys, {key});
        }
        orderedCharacteristics[0] = allKeys;
        orderedCharacteristics[1] = new String[allKeys.length];
        for (int i = 0; i < allKeys.length; ++i) {
            orderedCharacteristics[1][i] = this.characteristics.get(allKeys[i]);
        }
        StringBuilder sb = new StringBuilder();
        for (String[] line : orderedCharacteristics) {
            int i = 0;
            for (String s : line) {
                sb.append(s);
                if (++i >= line.length) continue;
                sb.append(",");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void printSolutionInfos() {
        String key;
        System.out.println("\n--- Best solution ---\n");
        for (String key2 : KEYS) {
            System.out.println(this.messages.get(key2) + this.characteristics.get(key2));
        }
        for (String key2 : this.objective.getAdditionalKeys()) {
            System.out.println(this.messages.get(key2) + this.characteristics.get(key2));
        }
        if (this.problem.hasMeshConstraint() && !(this.objective instanceof EffectiveMeshSizeObjective)) {
            key = "mesh";
            System.out.println(this.messages.get(key) + this.characteristics.get(key));
        }
        if (this.problem.hasIICConstraint() && !(this.objective instanceof IntegralIndexOfConnectivityObjective)) {
            key = "iic";
            System.out.println(this.messages.get(key) + this.characteristics.get(key));
        }
        System.out.println();
    }

    public AbstractRestoptObjective getObjective() {
        return this.objective;
    }

    public RestoptProblem getProblem() {
        return this.problem;
    }

    public int getMinRestoreArea() {
        if (this.problem.getMinRestore() != null) {
            return this.solution.getIntVal(this.problem.getMinRestore());
        }
        return 0;
    }

    public int getTotalRestorableArea() {
        if (this.problem.getTotalRestorable() != null) {
            return this.solution.getIntVal(this.problem.getTotalRestorable());
        }
        int maxRestore = 0;
        for (int i : this.getRestorationPlanningUnits()) {
            maxRestore += this.problem.getRestorableArea(i);
        }
        return maxRestore;
    }

    public int getNbComponents() {
        ConnectivityFinderSpatialGraph cf = new ConnectivityFinderSpatialGraph(this.getRestorationGraph());
        cf.findAllCC();
        return cf.getNBCC();
    }

    public double getDiameter() {
        int[] pus = this.getRestorationPlanningUnits();
        double[][] coordinates = new double[pus.length][];
        for (int i = 0; i < pus.length; ++i) {
            try {
                coordinates[i] = this.problem.getGrid().getCartesianCoordinates(pus[i]);
                continue;
            }
            catch (RestoptException e) {
                e.printStackTrace();
            }
        }
        double[] minidisk = LandscapeIndicesUtils.getSmallestEnclosingCircle(coordinates);
        if (minidisk.length == 0) {
            return 0.0;
        }
        return minidisk[2] * 2.0;
    }

    public int[] getRestorationPlanningUnits() {
        return this.solution.getSetVal(this.problem.getRestoreSetVar());
    }

    public int[] getRestorationPlanningUnitsCompleteIndex() {
        return IntStream.of(this.getRestorationPlanningUnits()).map(i -> this.problem.getGrid().getUngroupedCompleteIndex(i)).toArray();
    }

    public UndirectedGraph getRestorationGraph() {
        int[] pus = this.getRestorationPlanningUnits();
        UndirectedGraph g = GraphFactory.makeUndirectedGraph(this.problem.grid.getNbCells(), SetType.BIPARTITESET, SetType.BIPARTITESET, pus, new int[0][]);
        for (int i : pus) {
            for (int j : this.problem.getNeighborhood().getNeighbors(this.problem.getGrid(), i)) {
                if (!g.containsNode(j)) continue;
                g.addEdge(i, j);
            }
        }
        return g;
    }
}

