/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNotEqualX_Y
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;

    public PropNotEqualX_Y(IntVar x, IntVar y) {
        super((Variable[])ArrayUtils.toArray(x, y), (Priority)PropagatorPriority.BINARY, false);
        this.x = ((IntVar[])this.vars)[0];
        this.y = ((IntVar[])this.vars)[1];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (((IntVar[])this.vars)[vIdx].hasEnumeratedDomain()) {
            return IntEventType.instantiation();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.x.isInstantiated()) {
            if (this.y.removeValue(this.x.getValue(), this) || !this.y.contains(this.x.getValue())) {
                this.setPassive();
            }
        } else if (this.y.isInstantiated()) {
            if (this.x.removeValue(this.y.getValue(), this) || !this.x.contains(this.y.getValue())) {
                this.setPassive();
            }
        } else if (this.x.getUB() < this.y.getLB() || this.y.getUB() < this.x.getLB()) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() < this.y.getLB() || this.y.getUB() < this.x.getLB()) {
            return ESat.TRUE;
        }
        if (this.x.isInstantiated() && this.y.isInstantiated()) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        if (explanation.readVar(p) == ((IntVar[])this.vars)[0]) {
            assert (explanation.readDom(((IntVar[])this.vars)[1]).size() == 1);
            int m = explanation.readDom(((IntVar[])this.vars)[1]).min();
            IntIterableRangeSet set0 = explanation.universe();
            IntIterableRangeSet set1 = explanation.universe();
            set0.remove(m);
            set1.remove(m);
            ((IntVar[])this.vars)[0].intersectLit(set0, explanation);
            ((IntVar[])this.vars)[1].unionLit(set1, explanation);
        } else {
            assert (explanation.readDom(((IntVar[])this.vars)[0]).size() == 1);
            int m = explanation.readDom(((IntVar[])this.vars)[0]).min();
            IntIterableRangeSet set0 = explanation.universe();
            IntIterableRangeSet set1 = explanation.universe();
            set0.remove(m);
            set1.remove(m);
            ((IntVar[])this.vars)[0].unionLit(set0, explanation);
            ((IntVar[])this.vars)[1].intersectLit(set1, explanation);
        }
    }

    @Override
    public String toString() {
        return "prop(" + ((IntVar[])this.vars)[0].getName() + ".NEQ." + ((IntVar[])this.vars)[1].getName() + ")";
    }
}

