/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sat;

import gnu.trove.list.TIntList;
import java.util.ArrayList;
import org.chocosolver.sat.Literalizer;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.SatDecorator;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropSat
extends Propagator<Variable> {
    private final SatDecorator sat_;
    private final ArrayList<Variable> add_var;
    private boolean initialized = false;

    public PropSat(Model model) {
        super(new Variable[]{model.getNbVars() > 0 ? model.getVar(0) : model.boolVar(false)}, (Priority)PropagatorPriority.VERY_SLOW, true);
        this.vars = new Variable[0];
        this.sat_ = new SatDecorator(model);
        this.add_var = new ArrayList(16);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.initialize();
        if (!this.sat_.ok_) {
            this.fails();
        }
        this.sat_.cancelUntil(0);
        this.sat_.storeEarlyDeductions();
        this.sat_.applyEarlyDeductions(this);
        for (int i = 0; i < this.vars.length; ++i) {
            this.doBound(i);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.doBound(idxVarInProp);
    }

    protected void doBound(int i) throws ContradictionException {
        this.sat_.bound(this.vars[i], this);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.sat_.clauseEntailed(this.sat_.clauses) && this.sat_.clauseEntailed(this.sat_.dynClauses));
        }
        return ESat.UNDEFINED;
    }

    public MiniSat getMiniSat() {
        return this.sat_;
    }

    public void initialize() {
        if (!this.initialized) {
            if (this.add_var.size() > 0) {
                this.addVariable(this.add_var.toArray(new Variable[0]));
            }
            this.add_var.clear();
            this.initialized = true;
        }
    }

    public int makeBool(BoolVar expr) {
        return this.sat_.bind(expr, new Literalizer.BoolLit(expr), this::lazyAddVar);
    }

    public int makeIntEq(IntVar var, int val) {
        return this.sat_.bind(var, new Literalizer.IntEqLit(var, val), this::lazyAddVar);
    }

    public int makeIntLe(IntVar var, int val) {
        return this.sat_.bind(var, new Literalizer.IntLeLit(var, val), this::lazyAddVar);
    }

    public int makeSetIn(SetVar var, int val) {
        return this.sat_.bind(var, new Literalizer.SetInLit(var, val), this::lazyAddVar);
    }

    public void lazyAddVar(Variable var) {
        if (this.initialized) {
            this.addVariable(new Variable[]{var});
        } else {
            this.add_var.add(var);
        }
    }

    protected ESat value(int svar) {
        return this.sat_.value(svar);
    }

    public void beforeAddingClauses() {
        this.sat_.synchro();
    }

    public void afterAddingClauses() {
        this.sat_.storeEarlyDeductions();
    }

    public boolean addClause(TIntList lits) {
        boolean result = this.sat_.addClause(lits);
        this.sat_.storeEarlyDeductions();
        return result;
    }

    public void addLearnt(int ... lits) {
        this.sat_.learnClause(lits);
        this.forcePropagationOnBacktrack();
    }
}

