/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.chocosolver.solver.Identity;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropImplies
extends Propagator<Variable> {
    private final BoolVar impR;
    private final Constraint impC;
    private Constraint oppC = null;

    private static Variable[] extractVars(Constraint c, BoolVar r) {
        HashSet<BoolVar> setOfVars = new HashSet<BoolVar>();
        setOfVars.add(r);
        for (Propagator p : c.getPropagators()) {
            Collections.addAll(setOfVars, p.getVars());
        }
        Variable[] allVars = setOfVars.toArray(new Variable[0]);
        Arrays.sort(allVars, Comparator.comparingInt(Identity::getId));
        return allVars;
    }

    public PropImplies(Constraint c, BoolVar r) {
        super(PropImplies.extractVars(c, r), (Priority)PropagatorPriority.LINEAR, false);
        this.impC = c;
        this.impR = r;
        this.oppC = this.impC.getOpposite();
        this.impC.ignore();
        this.oppC.ignore();
        this.impC.setEnabled(false);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.impR.isInstantiated()) {
            if (this.impR.isInstantiatedTo(0)) {
                this.model.postTemp(this.oppC);
            }
            this.setPassive();
        } else {
            ESat sat = this.impC.isSatisfied();
            switch (sat) {
                case TRUE: {
                    this.impR.setToTrue(this);
                    this.setPassive();
                    break;
                }
                case FALSE: {
                    this.setPassive();
                }
            }
        }
    }

    @Override
    public ESat isEntailed() {
        switch (this.impC.isSatisfied()) {
            case TRUE: {
                return ESat.eval(this.impR.isInstantiatedTo(1));
            }
            case FALSE: {
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }
}

