/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.learn;

import java.util.Optional;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.learn.AbstractEventObserver;
import org.chocosolver.solver.learn.Implications;
import org.chocosolver.solver.learn.LazyImplications;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.IView;

public class EventRecorder
extends AbstractEventObserver {
    private final Implications mIG;

    public EventRecorder(Solver solver) {
        this.mIG = new LazyImplications(solver.getModel());
        solver.setEventObserver(this);
    }

    @Override
    public void removeValue(IntVar var, int val, ICause cause) {
        this.mIG.pushEvent(var, cause, IntEventType.REMOVE, val, -1, -1);
        for (int i = 0; i < var.getNbViews(); ++i) {
            IView<?> view = var.getView(i);
            if (view == cause) continue;
            view.justifyEvent(IntEventType.REMOVE, val, -1, -1);
        }
    }

    @Override
    public void updateLowerBound(IntVar var, int value, int old, ICause cause) {
        this.mIG.pushEvent(var, cause, IntEventType.INCLOW, value, old, -1);
        if (var.hasEnumeratedDomain() && !this.mIG.getDomainAt(this.mIG.size() - 1).isEmpty()) {
            value = this.mIG.getDomainAt(this.mIG.size() - 1).min();
        }
        for (int i = 0; i < var.getNbViews(); ++i) {
            IView<?> view = var.getView(i);
            if (view == cause) continue;
            view.justifyEvent(IntEventType.INCLOW, value, old, -1);
        }
    }

    @Override
    public void updateUpperBound(IntVar var, int value, int old, ICause cause) {
        this.mIG.pushEvent(var, cause, IntEventType.DECUPP, value, old, -1);
        if (var.hasEnumeratedDomain() && var.hasEnumeratedDomain() && !this.mIG.getDomainAt(this.mIG.size() - 1).isEmpty()) {
            value = this.mIG.getDomainAt(this.mIG.size() - 1).max();
        }
        for (int i = 0; i < var.getNbViews(); ++i) {
            IView<?> view = var.getView(i);
            if (view == cause) continue;
            view.justifyEvent(IntEventType.DECUPP, value, old, -1);
        }
    }

    @Override
    public void instantiateTo(IntVar var, int val, ICause cause, int oldLB, int oldUB) {
        this.mIG.pushEvent(var, cause, IntEventType.INSTANTIATE, val, oldLB, oldUB);
        for (int i = 0; i < var.getNbViews(); ++i) {
            IView<?> view = var.getView(i);
            if (view == cause) continue;
            view.justifyEvent(IntEventType.INSTANTIATE, val, oldLB, oldUB);
        }
    }

    @Override
    public void pushDecisionLevel() {
        this.mIG.tagDecisionLevel();
    }

    @Override
    public Optional<Implications> getGI() {
        return Optional.of(this.mIG);
    }

    @Override
    public void undo() {
        this.mIG.undoLastEvent();
    }
}

