/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.solver.IModel;
import org.chocosolver.solver.Identity;
import org.chocosolver.solver.ModelAnalyser;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cnf.SatConstraint;
import org.chocosolver.solver.constraints.real.IbexHandler;
import org.chocosolver.solver.constraints.unary.BooleanConstraint;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.objective.ObjectiveFactory;
import org.chocosolver.solver.propagation.PropagationEngine;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Group;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.util.tools.VariableUtils;
import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.filters.SizeOfFilter;

public final class Model
implements IModel {
    public static boolean MAXIMIZE = true;
    public static boolean MINIMIZE = false;
    public static final String TASK_SET_HOOK_NAME = "H_TASKSET";
    public static final String MINISAT_HOOK_NAME = "H_MINISAT";
    public static final String IBEX_HOOK_NAME = "H_IBEX";
    private final Settings settings;
    private final TIntObjectHashMap<IntVar> cachedConstants;
    private Variable[] vars;
    private int vIdx;
    private int nbIntVar;
    private int nbBoolVar;
    private int nbSetVar;
    private int nbRealVar;
    private Constraint[] cstrs;
    private int cIdx;
    private List<Group<?>> groups;
    private final IEnvironment environment;
    private final Solver solver;
    private Variable objective;
    private double precision = 1.0E-4;
    private String name;
    private final long creationTime;
    private int id = 1;
    private int nameId = 1;
    private final Map<String, Object> hooks;
    private ResolutionPolicy policy = ResolutionPolicy.SATISFACTION;
    private long seed = 0L;
    private ModelAnalyser modelAnalyser = null;
    private static int modelInitNumber;

    public Model(String name, Settings settings) {
        this.name = name;
        this.vars = new Variable[32];
        this.vIdx = 0;
        this.cstrs = new Constraint[32];
        this.cIdx = 0;
        this.environment = settings.getEnvironmentSupplier().get();
        this.creationTime = System.nanoTime();
        this.cachedConstants = new TIntObjectHashMap(16, 1.5f, Integer.MAX_VALUE);
        this.objective = null;
        this.hooks = new HashMap<String, Object>();
        this.settings = settings;
        this.solver = settings.initSolver(this);
        this.hooks.put("C_Undef", MiniSat.C_Undef);
        this.hooks.clear();
        this.groups = new ArrayList();
    }

    public Model(String name) {
        this(name, Settings.init());
    }

    public Model(Settings settings) {
        this("Model-" + Model.nextModelNum(), settings);
    }

    public Model() {
        this("Model-" + Model.nextModelNum());
    }

    private static synchronized int nextModelNum() {
        return modelInitNumber++;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public ResolutionPolicy getResolutionPolicy() {
        return this.policy;
    }

    public TIntObjectHashMap<IntVar> getCachedConstants() {
        return this.cachedConstants;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public Variable[] getVars() {
        return Arrays.copyOf(this.vars, this.vIdx);
    }

    public Stream<Variable> streamVars() {
        Spliterator it = Spliterators.spliterator(this.vars, 0, this.vIdx, 4417);
        return StreamSupport.stream(it, true);
    }

    public int getNbVars() {
        return this.vIdx;
    }

    public Variable getVar(int i) {
        return this.vars[i];
    }

    public int getNbIntVar(boolean includeBoolVar) {
        return this.nbIntVar + (includeBoolVar ? this.nbBoolVar : 0);
    }

    public IntVar[] retrieveIntVars(boolean includeBoolVar) {
        int size = this.getNbIntVar(includeBoolVar);
        IntVar[] ivars = new IntVar[size];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            int kind = this.vars[i].getTypeAndKind() & 0x3F8;
            if (kind != 8 && (!includeBoolVar || kind != 24)) continue;
            ivars[k++] = (IntVar)this.vars[i];
        }
        assert (k == size);
        return ivars;
    }

    public int getNbBoolVar() {
        return this.nbBoolVar;
    }

    public BoolVar[] retrieveBoolVars() {
        int size = this.getNbBoolVar();
        BoolVar[] bvars = new BoolVar[size];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0x3F8) != 24) continue;
            bvars[k++] = (BoolVar)this.vars[i];
        }
        assert (k == size);
        return bvars;
    }

    public int getNbSetVar() {
        return this.nbSetVar;
    }

    public SetVar[] retrieveSetVars() {
        int size = this.getNbSetVar();
        SetVar[] svars = new SetVar[size];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0x3F8) != 32) continue;
            svars[k++] = (SetVar)this.vars[i];
        }
        assert (k == size);
        return svars;
    }

    public int getNbRealVar() {
        return this.nbRealVar;
    }

    public RealVar[] retrieveRealVars() {
        int size = this.getNbRealVar();
        RealVar[] rvars = new RealVar[size];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0x3F8) != 64) continue;
            rvars[k++] = (RealVar)this.vars[i];
        }
        assert (k == size);
        return rvars;
    }

    public Constraint[] getCstrs() {
        return Arrays.copyOf(this.cstrs, this.cIdx);
    }

    public int getNbCstrs() {
        return this.cIdx;
    }

    public Stream<Constraint> streamCstrs() {
        Spliterator it = Spliterators.spliterator(this.cstrs, 0, this.cIdx, 4417);
        return StreamSupport.stream(it, true);
    }

    public String getName() {
        return this.name;
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public Variable getObjective() {
        return this.objective;
    }

    public double getPrecision() {
        return this.precision;
    }

    public Object getHook(String hookName) {
        return this.hooks.get(hookName);
    }

    public Object getHookOrDefault(String hookName, Object defaultValue) {
        return this.hooks.getOrDefault(hookName, defaultValue);
    }

    protected Map<String, Object> getHooks() {
        return this.hooks;
    }

    public <V extends Variable> void addGroup(Group<V> g) {
        this.groups.add(g);
    }

    @SafeVarargs
    public final <V extends Variable> void addAsGroup(String name, V ... vars) {
        this.addGroup(new Group(name, vars));
    }

    public List<Group<?>> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public BooleanConstraint trueConstraint() {
        return new BooleanConstraint(this, true);
    }

    public BooleanConstraint falseConstraint() {
        return new BooleanConstraint(this, false);
    }

    public Constraint voidConstraint() {
        return new Constraint("void", new Propagator[0]){

            @Override
            public void reifyWith(BoolVar bool) {
                throw new SolverException("Cannot reify a void constraint");
            }
        };
    }

    public SatConstraint getMinisat() {
        if (this.solver.isLCG()) {
            throw new UnsupportedOperationException("MiniSat is not supported with LCG");
        }
        if (this.getHook(MINISAT_HOOK_NAME) == null) {
            SatConstraint minisat = new SatConstraint(this);
            minisat.post();
            this.addHook(MINISAT_HOOK_NAME, minisat);
        }
        return (SatConstraint)this.getHook(MINISAT_HOOK_NAME);
    }

    public void removeMinisat() {
        if (this.getHook(MINISAT_HOOK_NAME) != null) {
            SatConstraint minisat = (SatConstraint)this.getHook(MINISAT_HOOK_NAME);
            this.unpost(minisat);
            this.removeHook(MINISAT_HOOK_NAME);
        }
    }

    public IbexHandler getIbexHandler() {
        if (this.getHook(IBEX_HOOK_NAME) == null) {
            IbexHandler ibexHnadler = new IbexHandler();
            ibexHnadler.setPreserveRounding(this.settings.getIbexRestoreRounding());
            this.addHook(IBEX_HOOK_NAME, ibexHnadler);
        }
        return (IbexHandler)this.getHook(IBEX_HOOK_NAME);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ModelAnalyser getModelAnalyser() {
        if (this.modelAnalyser == null) {
            this.modelAnalyser = new ModelAnalyser(this);
        }
        return this.modelAnalyser;
    }

    public long getEstimatedMemory() {
        long size = -1L;
        try {
            SizeOf sizeOf = SizeOf.newInstance(new SizeOfFilter(){

                @Override
                public Collection<Field> filterFields(Class<?> klazz, Collection<Field> fields) {
                    return fields;
                }

                @Override
                public boolean filterClass(Class<?> klazz) {
                    return !klazz.getName().contains("Lambda");
                }
            });
            size = sizeOf.deepSizeOf(this);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return size;
    }

    public void setObjective(boolean maximize, Variable objective) {
        if (objective == null) {
            throw new SolverException("Cannot set objective to null");
        }
        this.policy = maximize ? ResolutionPolicy.MAXIMIZE : ResolutionPolicy.MINIMIZE;
        this.objective = objective;
        if ((objective.getTypeAndKind() & 0x3F8) == 64) {
            this.getSolver().setObjectiveManager(ObjectiveFactory.makeObjectiveManager((RealVar)objective, this.policy, this.precision));
        } else {
            this.getSolver().setObjectiveManager(ObjectiveFactory.makeObjectiveManager((IntVar)objective, this.policy));
        }
    }

    public void clearObjective() {
        this.objective = null;
        this.policy = ResolutionPolicy.SATISFACTION;
        this.getSolver().setObjectiveManager(ObjectiveFactory.SAT());
    }

    public void setPrecision(double p) {
        this.precision = p;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void addHook(String hookName, Object hookObject) {
        this.hooks.put(hookName, hookObject);
    }

    public void removeHook(String hookName) {
        this.hooks.remove(hookName);
    }

    public void removeAllHooks() {
        this.hooks.clear();
    }

    public void setName(String name) {
        this.name = name;
        this.getSolver().getMeasures().setModelName(name);
    }

    public void associates(Variable variable) {
        if (this.vIdx == this.vars.length) {
            this.vars = Arrays.copyOf(this.vars, ArrayUtils.newBoundedSize(this.vars.length, this.vars.length * 2));
        }
        this.vars[this.vIdx++] = variable;
        switch (variable.getTypeAndKind() & 0x3F8) {
            case 8: {
                ++this.nbIntVar;
                break;
            }
            case 24: {
                ++this.nbBoolVar;
                break;
            }
            case 32: {
                ++this.nbSetVar;
                break;
            }
            case 64: {
                ++this.nbRealVar;
            }
        }
    }

    public void unassociates(Variable variable) {
        if (variable.getNbProps() > 0) {
            throw new SolverException("Try to remove a variable (" + variable.getName() + ")which is still involved in at least one constraint");
        }
        int idx = Arrays.binarySearch(this.vars, 0, this.vIdx, variable, Comparator.comparingInt(Identity::getId));
        System.arraycopy(this.vars, idx + 1, this.vars, idx + 1 - 1, this.vIdx - (idx + 1));
        this.vars[--this.vIdx] = null;
        switch (variable.getTypeAndKind() & 0x3F8) {
            case 8: {
                --this.nbIntVar;
                break;
            }
            case 24: {
                --this.nbBoolVar;
                break;
            }
            case 32: {
                --this.nbSetVar;
                break;
            }
            case 64: {
                --this.nbRealVar;
            }
        }
    }

    public int nextId() {
        return this.id++;
    }

    public int nextNameId() {
        return this.nameId++;
    }

    public void post(Constraint ... cs) throws SolverException {
        if (cs != null) {
            this._post(true, cs);
        }
    }

    private void _post(boolean permanent, Constraint ... cs) throws SolverException {
        PropagationEngine engine = this.getSolver().getEngine();
        boolean dynAdd = engine.isInitialized();
        if (this.cIdx + cs.length >= this.cstrs.length) {
            int nsize;
            for (nsize = this.cstrs.length; this.cIdx + cs.length >= nsize; nsize *= 2) {
            }
            this.cstrs = Arrays.copyOf(this.cstrs, nsize);
        }
        for (Constraint c : cs) {
            for (Propagator p : c.getPropagators()) {
                if (p.isPassive()) {
                    throw new SolverException("Try to add a constraint with a passive propagator");
                }
                p.getConstraint().checkNewStatus(Constraint.Status.POSTED);
                p.linkVariables();
            }
            if (dynAdd) {
                engine.dynamicAddition(permanent, c.getPropagators());
            }
            c.declareAs(Constraint.Status.POSTED, this.cIdx);
            this.cstrs[this.cIdx++] = c;
        }
    }

    public void postTemp(Constraint ... cs) throws ContradictionException {
        if (cs != null) {
            for (Constraint c : cs) {
                this.getEnvironment().save(() -> this.unpost(c));
                this._post(false, c);
                if (!this.getSolver().getEngine().isInitialized()) {
                    throw new SolverException("Try to post a temporary constraint while the resolution has not begun.\nA call to Model.post(Constraint) is more appropriate.");
                }
                for (Propagator p : c.getPropagators()) {
                    this.getSolver().getEngine().execute(p);
                }
            }
        }
    }

    public void unpost(Constraint ... constraints) throws SolverException {
        if (constraints != null) {
            for (Constraint c : constraints) {
                if (c.getStatus() != Constraint.Status.POSTED) {
                    throw new SolverException("The constraint " + c + " was not posted to the model and cannot be unposted");
                }
                int idx = c.getCidxInModel();
                c.declareAs(Constraint.Status.FREE, -1);
                c.ignore();
                Constraint cm = this.cstrs[--this.cIdx];
                if (idx < this.cIdx) {
                    this.cstrs[idx] = cm;
                    this.cstrs[idx].declareAs(Constraint.Status.FREE, -1);
                    this.cstrs[idx].declareAs(Constraint.Status.POSTED, idx);
                }
                this.cstrs[this.cIdx] = null;
                PropagationEngine engine = this.getSolver().getEngine();
                if (engine.isInitialized()) {
                    engine.dynamicDeletion(c.getPropagators());
                }
                for (Propagator prop : c.getPropagators()) {
                    prop.unlinkVariables();
                }
            }
        }
    }

    public String toString() {
        StringBuilder st = new StringBuilder(256);
        st.append(String.format("\n Model[%s]\n", this.name));
        st.append(String.format("\n[ %d vars -- %d cstrs -- %d lits -- %d clauses ]\n", this.vIdx, this.cIdx, this.getSolver().getSat() == null ? 0 : this.getSolver().getSat().nVars(), this.getSolver().getSat() == null ? 0 : this.getSolver().getSat().nClauses()));
        st.append(this.policy.name().toLowerCase()).append(" ");
        if (this.objective != null) {
            st.append(this.objective.getName()).append(" ");
        }
        st.append(" : ").append(this.getSolver().isFeasible().name().toLowerCase()).append("\n");
        st.append("== variables ==\n");
        for (int v = 0; v < this.vIdx; ++v) {
            st.append(this.vars[v].toString()).append('\n');
        }
        st.append("== constraints ==\n");
        for (int c = 0; c < this.cIdx; ++c) {
            st.append(this.cstrs[c].toString()).append('\n');
        }
        return st.toString();
    }

    public void displayVariableOccurrences() {
        HashMap<String, Integer> l = new HashMap<String, Integer>();
        int cnt = 0;
        for (Variable v : this.getVars()) {
            ++cnt;
            if (v.isAConstant()) {
                l.compute("constants", (n, k) -> k == null ? 1 : k + 1);
                continue;
            }
            if (VariableUtils.isView(v)) {
                l.compute("views", (n, k) -> k == null ? 1 : k + 1);
                continue;
            }
            if (VariableUtils.isInt(v)) {
                IntVar iv = v.asIntVar();
                l.compute(String.format("[%d,%d]", iv.getLB(), iv.getUB()), (n, k) -> k == null ? 1 : k + 1);
                continue;
            }
            l.compute(v.getClass().getSimpleName(), (n, k) -> k == null ? 1 : k + 1);
        }
        if (this.getSolver().getSat() != null && this.getSolver().getSat().nClauses() > 0) {
            l.put("lits", this.getSolver().getSat().nVars());
        }
        this.solver.log().bold().printf("== %d variables ==%n", cnt);
        l.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(e -> this.solver.log().printf("\t%s #%d\n", e.getKey(), e.getValue()));
    }

    public void displayPropagatorOccurrences() {
        HashMap<String, Integer> l = new HashMap<String, Integer>();
        int cnt = 0;
        for (Constraint c : this.getCstrs()) {
            for (Propagator p : c.getPropagators()) {
                l.compute(p.getClass().getSimpleName(), (n, k) -> k == null ? 1 : k + 1);
                ++cnt;
            }
        }
        if (this.getSolver().getSat() != null && this.getSolver().getSat().nClauses() > 0) {
            l.put("clauses", this.getSolver().getSat().nClauses());
        }
        this.solver.log().bold().printf("== %d propagators ==%n", cnt);
        l.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(e -> this.solver.log().printf("\t%s #%d\n", e.getKey(), e.getValue()));
    }

    @Override
    public Model ref() {
        return this;
    }
}

