/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.PropagationInsight;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.strategy.selectors.variables.AbstractCriterionBasedVariableSelector;
import org.chocosolver.solver.variables.Variable;

public class PickOnFil<V extends Variable>
extends AbstractCriterionBasedVariableSelector<V>
implements IMonitorContradiction {
    private ArrayList<Propagator<?>> Lcstrs;
    private TLongArrayList Ldeltas;
    private final int variant;

    public PickOnFil(V[] vars) {
        this((Variable[])vars, 3, 32);
    }

    public PickOnFil(V[] vars, int variant, int flushRate) {
        super(vars, 0L, flushRate);
        this.variant = variant;
    }

    @Override
    public boolean init() {
        PropagationInsight.PickOnFil pi = new PropagationInsight.PickOnFil();
        this.solver.getEngine().setInsight(pi);
        this.Lcstrs = pi.getLcstrs();
        this.Ldeltas = pi.getLdeltas();
        if (!this.solver.getSearchMonitors().contains(this)) {
            this.solver.plugMonitor(this);
        }
        return true;
    }

    @Override
    public final void remove() {
        if (this.solver.getSearchMonitors().contains(this)) {
            this.solver.unplugMonitor(this);
        }
    }

    @Override
    protected double weight(V v) {
        return this.weights.get(v);
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        switch (this.variant) {
            case 0: {
                for (int i = 0; i < this.Lcstrs.size(); ++i) {
                    Propagator<?> lc = this.Lcstrs.get(i);
                    for (Variable lv : lc.getVars()) {
                        this.weights.adjustOrPutValue(lv, 1.0, 1.0);
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.Lcstrs.size(); ++i) {
                    Propagator<?> lc = this.Lcstrs.get(i);
                    for (Variable lv : lc.getVars()) {
                        this.weights.adjustOrPutValue(lv, this.Ldeltas.get(i), this.Ldeltas.get(i));
                    }
                }
                break;
            }
            case 2: {
                long sum = this.Ldeltas.sum();
                double r = 100.0 / (double)sum;
                for (int i = 0; i < this.Lcstrs.size(); ++i) {
                    double amnt = r * (double)this.Ldeltas.get(i);
                    Propagator<?> lc = this.Lcstrs.get(i);
                    for (Variable lv : lc.getVars()) {
                        this.weights.adjustOrPutValue(lv, amnt, amnt);
                    }
                }
                break;
            }
            case 3: {
                double n = (double)this.solver.getModel().getNbVars() * 1.0;
                double d = (double)this.solver.getCurrentDepth() * 1.0;
                long sum = this.Ldeltas.sum();
                double r = (n - d) / n * 100.0 / (double)sum;
                for (int i = 0; i < this.Lcstrs.size(); ++i) {
                    double amnt = r * (double)this.Ldeltas.get(i);
                    Propagator<?> lc = this.Lcstrs.get(i);
                    for (Variable lv : lc.getVars()) {
                        this.weights.adjustOrPutValue(lv, amnt, amnt);
                    }
                }
                break;
            }
        }
    }

    @Override
    void increase(Propagator<?> prop, AbstractCriterionBasedVariableSelector.Element elt, double[] ws) {
    }

    @Override
    public void afterRestart() {
        if (this.flushWeights(this.weights)) {
            this.weights.clear();
        }
    }
}

