test_that("Number of real roots in bounded interval.", {
  x <- qlone(1)
  p <- (x - 2)*(x - 4)*(x - 6)*(x - 8)*(x - 10)
  expect_identical(numberOfRealRootsInInterval(p, 0, 12), 5L)
  expect_identical(numberOfRealRootsInInterval(p, 0, 8), 4L)
  expect_identical(numberOfRealRootsInInterval(p, 0, 8, closed = FALSE), 3L)
  expect_identical(numberOfRealRootsInInterval(p, 2, 8), 4L)
  expect_identical(numberOfRealRootsInInterval(p, 2, 8, closed = FALSE), 2L)
  expect_identical(numberOfRealRootsInInterval(x^4 + 1, -20, 20), 0L)
  expect_identical(numberOfRealRootsInInterval(x^4 + 1, -20, 20, FALSE), 0L)
})

test_that("Number of real roots in unbounded interval.", {
  x <- qlone(1)
  p <- (x - 2)*(x - 4)*(x - 6)*(x - 8)*(x - 10)
  expect_identical(numberOfRealRootsInInterval(p, -Inf, Inf), 5L)
  expect_identical(numberOfRealRootsInInterval(p, 0, Inf), 5L)
  expect_identical(numberOfRealRootsInInterval(p, -Inf, 8), 4L)
  expect_identical(numberOfRealRootsInInterval(p, -Inf, 8, closed = FALSE), 3L)
  expect_identical(numberOfRealRootsInInterval(p, 2, Inf), 5L)
  expect_identical(numberOfRealRootsInInterval(p, 2, Inf, closed = FALSE), 4L)
  expect_identical(numberOfRealRootsInInterval(x^4 + 1, -Inf, Inf), 0L)
  expect_identical(numberOfRealRootsInInterval(x^4 + 1, -Inf, 20), 0L)
  expect_identical(numberOfRealRootsInInterval(x^4 + 1, -Inf, 20, FALSE), 0L)
  expect_identical(numberOfRealRootsInInterval(x^4 + 1, -20, Inf), 0L)
  expect_identical(numberOfRealRootsInInterval(x^4 + 1, -20, Inf, FALSE), 0L)
})
