% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureSetCommon.R
\name{FeatureSetCommon}
\alias{FeatureSetCommon}
\title{Class containing functionality common to \code{\link{FeatureSet}}s and
  \code{\link{ReconstructedFeatureSet}}s}
\description{
An FeatureSetCommon has functionality for retrieving
  sets of features (e.g. points or landmarks associated with an
  outline)
}
\author{
David Sterratt
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{List of matrices describing data}

\item{\code{cols}}{Vector of colours for each data set}

\item{\code{type}}{String giving type of feature set}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FeatureSetCommon-getIndex}{\code{FeatureSetCommon$getIndex()}}
\item \href{#method-FeatureSetCommon-getIDs}{\code{FeatureSetCommon$getIDs()}}
\item \href{#method-FeatureSetCommon-setID}{\code{FeatureSetCommon$setID()}}
\item \href{#method-FeatureSetCommon-getFeature}{\code{FeatureSetCommon$getFeature()}}
\item \href{#method-FeatureSetCommon-getFeatures}{\code{FeatureSetCommon$getFeatures()}}
\item \href{#method-FeatureSetCommon-getCol}{\code{FeatureSetCommon$getCol()}}
\item \href{#method-FeatureSetCommon-clone}{\code{FeatureSetCommon$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FeatureSetCommon-getIndex"></a>}}
\if{latex}{\out{\hypertarget{method-FeatureSetCommon-getIndex}{}}}
\subsection{Method \code{getIndex()}}{
Get numeric index of features
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getIndex(fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{Feature ID (string)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FeatureSetCommon-getIDs"></a>}}
\if{latex}{\out{\hypertarget{method-FeatureSetCommon-getIDs}{}}}
\subsection{Method \code{getIDs()}}{
Get IDs of features
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Vector of IDs of features
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FeatureSetCommon-setID"></a>}}
\if{latex}{\out{\hypertarget{method-FeatureSetCommon-setID}{}}}
\subsection{Method \code{setID()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$setID(i, fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Numeric index of feature}

\item{\code{fid}}{Feature ID (string)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FeatureSetCommon-getFeature"></a>}}
\if{latex}{\out{\hypertarget{method-FeatureSetCommon-getFeature}{}}}
\subsection{Method \code{getFeature()}}{
Get feature by feature ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getFeature(fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{Feature ID string}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix describing feature
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FeatureSetCommon-getFeatures"></a>}}
\if{latex}{\out{\hypertarget{method-FeatureSetCommon-getFeatures}{}}}
\subsection{Method \code{getFeatures()}}{
Get all features
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getFeatures()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FeatureSetCommon-getCol"></a>}}
\if{latex}{\out{\hypertarget{method-FeatureSetCommon-getCol}{}}}
\subsection{Method \code{getCol()}}{
Get colour in which to plot feature ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$getCol(fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{Feature ID string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FeatureSetCommon-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FeatureSetCommon-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureSetCommon$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
