% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReconstructedFeatureSet.R
\name{ReconstructedFeatureSet}
\alias{ReconstructedFeatureSet}
\title{Class containing functions and data to map \link{FeatureSet}s to
\link{ReconstructedOutline}s}
\description{
A ReconstructedFeatureSet contains information about
  features located on \code{\link{ReconstructedOutline}}s. Each
  ReconstructedFeatureSet contains a list of matrices, each of
  which has columns labelled \code{phi} (latitude) and
  \code{lambda} (longitude) describing the spherical coordinates
  of points on the ReconstructedOutline. Derived classes, e.g. a
  \code{\link{ReconstructedCountSet}}, may have extra columns.
  Each matrix in the list has an associated label and colour,
  which is used by plotting functions.
}
\author{
David Sterratt
}
\section{Super class}{
\code{\link[retistruct:FeatureSetCommon]{retistruct::FeatureSetCommon}} -> \code{ReconstructedFeatureSet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ReconstructedFeatureSet-new}{\code{ReconstructedFeatureSet$new()}}
\item \href{#method-ReconstructedFeatureSet-clone}{\code{ReconstructedFeatureSet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getCol"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getCol'><code>retistruct::FeatureSetCommon$getCol()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getFeature"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getFeature'><code>retistruct::FeatureSetCommon$getFeature()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getFeatures"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getFeatures'><code>retistruct::FeatureSetCommon$getFeatures()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getIDs"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getIDs'><code>retistruct::FeatureSetCommon$getIDs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getIndex"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getIndex'><code>retistruct::FeatureSetCommon$getIndex()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="setID"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-setID'><code>retistruct::FeatureSetCommon$setID()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedFeatureSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedFeatureSet-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedFeatureSet$new(fs = NULL, ro = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fs}}{\code{\link{FeatureSet}} to reconstruct}

\item{\code{ro}}{\code{\link{ReconstructedOutline}} to which feature
set should be mapped}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReconstructedFeatureSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ReconstructedFeatureSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReconstructedFeatureSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
