% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rprior.R
\name{rDir}
\alias{rDir}
\title{Simulation from a Dirichlet distribution}
\usage{
rDir(n = 1, alpha = c(1, 1))
}
\arguments{
\item{n}{A numeric scalar. The size of sample required.}

\item{alpha}{A numeric vector.  Dirichlet concentration parameter.}
}
\value{
An \code{n} by \code{length(alpha)} numeric matrix.
}
\description{
Simulates from a Dirichlet distribution with concentration parameter
vector \eqn{\alpha} = (\eqn{\alpha_1}, ..., \eqn{\alpha_K}).
}
\details{
The simulation is based on the property that if
  \eqn{Y_1}, ..., \eqn{Y_K} are independent, \eqn{Y_i} has a
  gamma(\eqn{\alpha_i}, 1) distribution and \eqn{S = Y_1 + ... + Y_k}
  then \eqn{(Y_1, ..., Y_K) / S} has a
  Dirichlet(\eqn{\alpha_1}, ..., \eqn{\alpha_K}) distribution.

  See
\url{https://en.wikipedia.org/wiki/Dirichlet_distribution#Gamma_distribution}
}
\examples{
rDir(n = 10, alpha = 1:4)
}
\references{
Kotz, S., Balakrishnan, N. and Johnson, N. L. (2000)
  \emph{Continuous Multivariate Distributions, vol. 1, Models and
  Applications, 2nd edn}, ch. 49. New York: Wiley.
  \url{http://dx.doi.org/10.1002/0471722065}
}
\seealso{
\code{\link{rprior_prob}} for prior simulation of
  GEV parameters - prior on probability scale.
}
