% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/match.R
\name{re_matches}
\alias{re_matches}
\title{Match function}
\usage{
re_matches(data, pattern, global = FALSE, options = NULL,
  locations = FALSE, ...)
}
\arguments{
\item{data}{character vector to match against}

\item{pattern}{regular expression to use for matching}

\item{global}{use global matching}

\item{options}{regular expression options}

\item{locations}{rather than returning the values of the matched (or
captured) string, return a \code{data.frame} of the match locations in the
string.}

\item{...}{options passed to regexpr or gregexpr}
}
\value{
if no captures, returns a logical vector the same length as the
input character vector specifying if the relevant value matched or not.  If
there are captures in the regular expression, returns a \code{data.frame} with a
column for each capture group.  If \code{global} is \code{TRUE}, returns a
list of \code{data.frame}s.
}
\description{
Match function
}
\examples{
string = c("this is a", "test string")
re_matches(string, rex("test")) # FALSE FALSE

# named capture
re_matches(string, rex(capture(alphas, name = "first_word"), space,
  capture(alphas, name = "second_word")))
#   first_word second_word
# 1       this          is
# 2       test      string

# capture returns NA when it fails to match
re_matches(string, rex(capture("test")))
#      1
# 1 test
# 2 <NA>
}
\seealso{
\code{\link{regexp}} Section "Perl-like Regular Expressions" for a
discussion of the supported options
}

