% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPredictedProbs.R
\name{plotPredictedProbs}
\alias{plotPredictedProbs}
\title{Plot Predicted Probabilities}
\usage{
plotPredictedProbs(rf, bins = 30, plot = TRUE)
}
\arguments{
\item{rf}{an object inheriting from \code{\link{randomForest}}.}

\item{bins}{number of bins in histogram. Defaults to number of samples / 5.}

\item{plot}{display the plot?}
}
\value{
the \code{ggplot2} object is invisibly returned.
}
\description{
Plot histogram of assignment probabilities to predicted class. 
  This is used for determining if the model differentiates between correctly 
  and incorrectly classified samples in terms of how well they ar classified.
}
\examples{
data(mtcars)

rf <- randomForest(factor(am) ~ ., mtcars)
plotPredictedProbs(rf, bins = 20)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
