% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexscan.R
\name{plot.rflexscan}
\alias{plot.rflexscan}
\title{Graph plotting of flexscan results}
\usage{
\method{plot}{rflexscan}(x, rank = 1:length(x$cluster), pval = 1,
  vertexsize = max(x$input$coordinates[, 1]) - min(x$input$coordinates[,
  1]), xlab = colnames(x$input$coordinates)[1],
  ylab = colnames(x$input$coordinates)[2],
  xlim = c(min(x$input$coordinates[, 1]), max(x$input$coordinates[, 1])),
  ylim = c(min(x$input$coordinates[, 2]), max(x$input$coordinates[, 2])),
  col = palette(), frame_color = "gray40", vertex_color = "white",
  ...)
}
\arguments{
\item{x}{An rflexscan object.}

\item{rank}{An integer vector which specifies ranks of clusters to be displayed.}

\item{pval}{A threshold of P-value. Clusters with P-values of <\code{pval} will be displayed.}

\item{vertexsize}{Size of vertex of the graph.}

\item{xlab}{A label of the x axis.}

\item{ylab}{A label of the y axis.}

\item{xlim}{The x limits of the plot.}

\item{ylim}{The y limits of the plot.}

\item{col}{A vector of colors for each cluster.}

\item{frame_color}{Color of frames in the graph.}

\item{vertex_color}{Fill color of vertices that are not included in any clusters.}

\item{...}{Other parameters to be passed to \link{plot.igraph} function.}
}
\description{
Display detected clusters by a graph representation.
}
\details{
Clusters are colored using the current palette. Please use \link{palette}
function to specify colors of each cluster. Note that clusters with ranks
larger than the number of colors in the palette are not highlighted.
}
\examples{
# load sample data (North Carolina SIDS data)
library(spdep)
data("nc.sids")

# calculate the expected numbers of cases
expected <- nc.sids$BIR74 * sum(nc.sids$SID74) / sum(nc.sids$BIR74)

# run FleXScan
fls <- rflexscan(x = nc.sids$x, y = nc.sids$y,
                 observed = nc.sids$SID74,
                 expected = expected,
                 name = rownames(nc.sids),
                 clustersize = 10,
                 nb = ncCR85.nb)

# display all clusters
plot(fls)

# display clusters with rank 1, 2 and 3
plot(fls, rank = c(1, 2, 3))

# display clusters of P-value <= 0.05
plot(fls, pval = 0.05)

}
\seealso{
\link{rflexscan}
}
