% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-ml.data.frame.R
\name{ml.data.frame}
\alias{ml.data.frame}
\title{Creates a \link{ml.data.frame} object}
\usage{
ml.data.frame(conn, query = "", fieldFilter = "", ns = "NA",
  collection = c(), directory = c(), relevanceScores = FALSE,
  docUri = FALSE)
}
\arguments{
\item{conn}{A \link{ml.conn-class} object created by \link{ml.connect}}

\item{query}{The query string used to define the result, see details for more information about syntax.}

\item{fieldFilter}{Field level filtering. Multiple field filters are separated by , See details for limitations.}

\item{ns}{A character with the namespace URI to be used with fieldFilter, default is none}

\item{collection}{A list of collection URI:s to filter on.}

\item{directory}{A list of directory URI:s to filter on.}

\item{relevanceScores}{TRUE/FALSE. If the result attributes score, confidence and fitness should be included. Default is FALSE}

\item{docUri}{TRUE/FALSE. If the uri of the documents in the results should be included. Default is FALSE.}
}
\value{
A ml.data.frame object.
}
\description{
A ml.data.frame object is an abstraction layer of data stored in a MarkLogic Server database. It is created based
on the provided query, collection, directory and/or fiedlFilter parameters. For query and fieldFilter
parameters see details section. It present data in MarkLogic Server in a tabular format.
The ml.data.frame object enables many of the operations that can be used with a data.frame object.
}
\details{
The query parameter are using the \href{http://docs.marklogic.com/guide/search-dev/string-query}{string search grammar}
for searching for data, all of the syntax is supported except contstraints. This enables searches such as
"dog AND cat"  or "dog NEAR cat". The search is always done on all fields in the data, for a more precise search
use the fieldFilter.

fieldFilter enables filtering on a specific field using comparison operators can be used. For
the ">"  "<"  "!=" "<=" ">=" operators there muset exist a
\href{http://docs.marklogic.com/guide/admin/range_index#id_93351}{element range index}
on the source field or a error will be raised, element range index can be created using the \link{ml.add.index}
function. "==" operator will always work since it does not depend of range indexes.
}
\examples{
\dontrun{
 library(rfml)
 localConn <- ml.connect()
 # create a ml.data.frame based on a search
 mlIris <- ml.data.frame(localConn, "setosa")
 # using search and collection filtering
 mlIris <- ml.data.frame(localConn, "setosa", collection = "iris")
 # using field filter
 mlIris <- ml.data.frame(localConn, fieldFilter = "Species == setosa")
}
}
\seealso{
\code{\link[rfml]{as.data.frame}} for pulling data, \code{\link{as.ml.data.frame}} for uploading data, \code{\link{rm.ml.data.frame}} for delete uploaded data
}

