% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_spellcheck.R
\name{occ_spellcheck}
\alias{occ_spellcheck}
\title{Spell check search term for occurrence searches}
\usage{
occ_spellcheck(search, ...)
}
\arguments{
\item{search}{(character) query term}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will
be combined with \code{\link[httr]{config}}.}
}
\value{
A boolean if search term spelled correctly, or if not spelled
correctly with no suggested alternatives. If spelled incorrectly and
suggested alternatives given, we give back a list with slots
"correctlySpelled" (boolean) and "suggestions" (list)
}
\description{
Spell check search term for occurrence searches
}
\examples{
\dontrun{
# incorrectly spelled, with suggested alternative
occ_spellcheck(search = "kajsdkla")

# incorrectly spelled, without > 1 suggested alternative
occ_spellcheck(search = "helir")

# incorrectly spelled, without no alternatives
occ_spellcheck(search = "asdfadfasdf")

# correctly spelled,  alternatives
occ_spellcheck(search = "helianthus")
}
}

