#' Get List of Most Recent Fills
#'
#' @name fills
#'
#' @description This is an auth based function. User must have valid api keys generated by GADX which must be passed as mandatory arguments. The functions takes no additional arguments and returns a list of all previously filled orders.
#'
#' @param api.key Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.
#' @param secret Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.
#' @param passphrase Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.
#'
#' @return  Dataframe with fills for all products or for the provided products. The volume is quoted in USD.
#'
#' @examples
#' \dontrun{
#' fills(api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
#' }
#'
#' @export


fills <-
  function(api.key,
           secret,
           passphrase) {
    #get url extension----
    req.url = "/fills"

    #get method----
    method <- "GET"

    #fetch response----
    fills <- auth(
      method = method,
      req.url = req.url,
      api.key = api.key,
      secret = secret,
      passphrase = passphrase
    )

    #transform----
    fills$price <- as.numeric(fills$price)
    fills$size <- as.numeric(fills$size)
    fills$fee <- as.numeric(fills$fee)
    fills$usd_volume <- as.numeric(fills$usd_volume)
    fills$created_at <- strptime(fills$created_at, "%Y-%m-%dT%H:%M:%OS")

    #return----
    return(fills)
  }
