% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{join_count_ratio}
\alias{join_count_ratio}
\title{Join Count Ratio}
\usage{
join_count_ratio(clusters, w)
}
\arguments{
\item{clusters}{A cluster classification variable (categorical values from a dataframe or values returned from cluster functions)}

\item{w}{An instance of Weight class}
}
\value{
A data.frame with names "Cluster", "N", "Neighbors", "Join Count", "Ratio"
}
\description{
Join count ratio is the join counts, the number of times a category is surrounded
by neighbors of the same category, over the total number of neighbors after converting
each category to a dummy variable.
}
\examples{
\dontrun{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
data <- guerry[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants','Suicids')]
clusters <- skater(5, queen_w, data)
results <- join_count_ratio(clusters, queen_w)
results
}
}
