% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gn_parse_tidy.R
\name{gn_parse_tidy}
\alias{gn_parse_tidy}
\title{gn_parse_tidy}
\usage{
gn_parse_tidy(x, threads = 4, batch_size = NULL, ignore_tags = FALSE)
}
\arguments{
\item{x}{(character) vector of scientific names. required}

\item{threads}{(integer/numeric) number of threads to run. CPU's
threads number is the default. default: \code{4}}

\item{batch_size}{(integer/numeric) maximum number of names in a
batch send for processing. default: \code{NULL}}

\item{ignore_tags}{(logical) ignore HTML entities and tags when
parsing. default: \code{FALSE}}
}
\value{
a data.frame
}
\description{
extract names using gnparser into a tidy tibble
}
\details{
This function focuses on a data.frame result that's easy
to munge downstream - note that this function does not do additional
details as does \code{\link[=gn_parse]{gn_parse()}}.
}
\examples{
trys <- function(x) try(x, silent=TRUE)
if (interactive()) {
x <- c("Quadrella steyermarkii (Standl.) Iltis & Cornejo",
  "Parus major Linnaeus, 1788", "Helianthus annuus var. texanus")
trys(gn_parse_tidy(x))
}
}
