% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{add_create_shape_request}
\alias{add_create_shape_request}
\title{Add a create shape request}
\usage{
add_create_shape_request(google_slides_request = NULL, shape_type,
  page_element_property, object_id = NULL)
}
\arguments{
\item{google_slides_request}{(Optional) A Google Slides Request object which is used to manage requests to the API}

\item{shape_type}{A character vector that contains the shape type for the new shape that is to be created}

\item{page_element_property}{A list that contains a page element property. The page element is to be
generated by the page_element_property function in this package. IT IS COMPULSORY TO ADD WIDTH AND HEIGHT AS
PART OF THE page_element_property}

\item{object_id}{(Optional) A character vector to name the object created instead of leaving it to Google}
}
\description{
This function builds up the request for creating shapes within Googleslides via the API.
}
\examples{
\dontrun{
library(rgoogleslides)
rgoogleslides::authorize()

# Define the presentation slide id (Can be retrieved from the url of the slides)
slides_id <- "<slide-id>"

slide_page <- page_element_property("p", 200, 300)
request <- add_create_shape_request(shape_type = "RECTANGLE", page_element_property = slide_page)
commit_to_slides(slides_id, request)

slide_page <- aligned_page_element_property("p", image_height = 200, image_width = 300)
request2 <- add_create_shape_request(shape_type = "STAR_5", page_element_property = slide_page)
commit_to_slides(slides_id, request2)
}
}
