% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-preprocessing.R
\name{Padding}
\alias{Padding}
\title{Preprocessing: Padding}
\description{
This is a class for padding a list of persistence diagrams with
dummy points, so that all persistence diagrams end up with the same number
of points.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
pad <- Padding$new()
pad$apply(dgm)
pad$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:PreprocessingStep]{rgudhi::PreprocessingStep}} -> \code{Padding}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Padding-new}{\code{Padding$new()}}
\item \href{#method-Padding-clone}{\code{Padding$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="apply"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-apply'><code>rgudhi::PreprocessingStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="fit"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-fit'><code>rgudhi::PreprocessingStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="fit_transform"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-fit_transform'><code>rgudhi::PreprocessingStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="transform"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-transform'><code>rgudhi::PreprocessingStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Padding-new"></a>}}
\if{latex}{\out{\hypertarget{method-Padding-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{Padding}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Padding$new(use = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use}}{A boolean value specifying whether to use the class. Defaults
to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{Padding}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Padding-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Padding-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Padding$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
