% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-scalers.R
\name{StandardScaler}
\alias{StandardScaler}
\title{Standardizes features by removing the mean and scaling to unit variance}
\description{
The standard score of a sample x is calculated as:
\deqn{z = \frac{(x - u)}{s}}
where \eqn{u} is the mean of the training samples or 0 if \code{with_mean = FALSE}, and \eqn{s} is the standard deviation of the training samples or 1 if
\code{with_std = FALSE}.

Standardization of a dataset is a common requirement for many machine
learning estimators: they might behave badly if the individual features do
not more or less look like standard normally distributed data (e.g. Gaussian
with 0 mean and unit variance).

For instance many elements used in the objective function of a learning
algorithm (such as the RBF kernel of Support Vector Machines or the L1 and L2
regularizers of linear models) assume that all features are centered around 0
and have variance in the same order. If a feature has a variance that is
orders of magnitude larger than others, it might dominate the objective
function and make the estimator unable to learn from other features correctly
as expected.

This scaler can also be applied to sparse CSR or CSC matrices by passing
\code{with_mean = FALSE} to avoid breaking the sparsity structure of the data.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.preprocessing")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ss <- StandardScaler$new()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseScaler]{rgudhi::BaseScaler}} -> \code{StandardScaler}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StandardScaler-new}{\code{StandardScaler$new()}}
\item \href{#method-StandardScaler-clone}{\code{StandardScaler$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StandardScaler-new"></a>}}
\if{latex}{\out{\hypertarget{method-StandardScaler-new}{}}}
\subsection{Method \code{new()}}{
The \link{StandardScaler} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StandardScaler$new(copy = TRUE, with_mean = TRUE, with_std = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{copy}}{A boolean value specifying whether to perform in-place
scaling and avoid a copy (if the input is already a numpy array).
Defaults to \code{TRUE}.}

\item{\code{with_mean}}{A boolean value specifying whether to center the data
before scaling. This does not work (and will raise an exception) when
attempted on sparse matrices, because centering them entails building a
dense matrix which in common use cases is likely to be too large to fit
in memory. Defaults to \code{TRUE}.}

\item{\code{with_std}}{A boolean value specifying whether to scale the data to
unit variance (or equivalently, unit standard deviation). Defaults to
\code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{StandardScaler}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StandardScaler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StandardScaler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StandardScaler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
