% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realms.R
\name{BCADtoC14}
\alias{BCADtoC14}
\title{Find the 14C age and error belonging to a BC/AD age.}
\usage{
BCADtoC14(
  x,
  cc = 1,
  postbomb = FALSE,
  zero = TRUE,
  rule = 1,
  cc.dir = NULL,
  thiscurve = NULL
)
}
\arguments{
\item{x}{The BC/AD year.}

\item{cc}{calibration curve for C14 (see \code{caldist()}).}

\item{postbomb}{Whether or not to use a postbomb curve (see \code{caldist()}).}

\item{zero}{Whether or not to include 0 in BC/AD years. Defaults to TRUE.}

\item{rule}{How should R's approx function deal with extrapolation. If \code{rule=1}, the default, then NAs are returned for such points and if it is 2, the value at the closest data extreme is used.}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}
}
\value{
The calibration-curve 14C year belonging to the entered BC/AD age
}
\description{
Given a calendar age, the calibration curve (default cc=1) is interpolated and the corresponding 14C age and error are returned. BC ages are negative. In this implementation, the year 0 BC/AD does exist.
}
\details{
Interpolation is used, and values outside the calibration curve are given as NA. For ages younger than AD 1950, a postbomb curve will have to be provided.
}
\examples{
  BCADtoC14(100)
}
\author{
Maarten Blaauw
}
