% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realms.R
\name{C14topMC}
\alias{C14topMC}
\title{Calculate pMC values from C14 ages}
\usage{
C14topMC(y, er = NULL, roundby = NA, lambda = 8033)
}
\arguments{
\item{y}{Reported mean of the C14 age.}

\item{er}{Reported error of the C14 age.}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=NA}, no rounding.}

\item{lambda}{The mean-life of radiocarbon (based on Libby half-life of 5568 years)}
}
\value{
pMC values from C14 ages.
}
\description{
Calculate pMC values from radiocarbon ages
}
\details{
Post-bomb dates are often reported as pMC or percent modern carbon. Since Bacon expects radiocarbon ages,
this function can be used to calculate pMC values from radiocarbon ages. The reverse function of \link{pMCtoC14}.
}
\examples{
  C14topMC(-2000, 20)
  C14topMC(-2000, 20, 1)
}
