% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sources.R
\name{clean}
\alias{clean}
\title{Simulate removing contamination from a radiocarbon age}
\usage{
clean(
  y,
  er = 0,
  percentage,
  percentage.error = 0.001,
  F.contam = 1,
  F.contam.er = 0.001,
  MC = TRUE,
  seed = NA,
  its = 10000,
  roundby = 1,
  decimals = 5,
  visualise = TRUE,
  talk = TRUE,
  eq.x = 5,
  eq.y = c(),
  eq.size = 0.75,
  true.col = "darkgreen",
  observed.col = "blue",
  contamination.col = "red",
  true.pch = 20,
  observed.pch = 18,
  contamination.pch = 17,
  true.name = "true",
  xlab = "contamination (\%)",
  ylab = "F14C",
  ylim = c(),
  C14.axis = TRUE,
  bty = "u"
)
}
\arguments{
\item{y}{The observed radiocarbon age}

\item{er}{The error of the observed radiocarbon age}

\item{percentage}{Relative amount of contamination. Must be between 0 and 100 (\%)}

\item{percentage.error}{Uncertainty of the contamination. Assumed to be normally distributed (which fails close to 0\% or 100\% contamination levels). Defaults to a very small but >0 value, 0.001\%.}

\item{F.contam}{The F14C of the contamination. Set at 1 for carbon of modern radiocarbon age, at 0 for 14C-free carbon, or anywhere inbetween.}

\item{F.contam.er}{The error of the contamination. Defaults to a very small but >0 value, 0.001\%.}

\item{MC}{Whether or not to use Monte Carlo iterations to estimate the values. Defaults to TRUE, because it treats uncertainties better than if set to FALSE.}

\item{seed}{For reproducibility, a seed can be set (e.g., \code{seed=123}). Defaults to NA, no seed set.}

\item{its}{Amount of iterations to use if MC=TRUE. Defaults to 10,000.}

\item{roundby}{Rounding of the output for C14 ages. Defaults to 1 decimal.}

\item{decimals}{Rounding of the output. Since details matter here, the default is to provide 5 decimals.}

\item{visualise}{By default, a plot is made to visualise the target and observed F14C values, together with the inferred contamination.}

\item{talk}{Whether or not to report the calculations made. Defaults to \code{talk=TRUE}.}

\item{eq.x}{Leftmost location of the equation. Defaults to \code{eq.x=5}. Can be set to values outside of (0,100) to make the equation invisible.}

\item{eq.y}{Vertical location of the equation. Defaults to the top of the graph.}

\item{eq.size}{Size of the font of the equation. In case the equation gets jumbled up upon resizing of a graphical device, just issue the previous `clean` command again. Defaults to \code{eq.size=0.8}.}

\item{true.col}{Colour for the target/true values. Defaults to "darkgreen".}

\item{observed.col}{Colour for the observed values. Defaults to blue.}

\item{contamination.col}{Colour for the contamination values. Defaults to red.}

\item{true.pch}{Icon for the true/target date. Defaults to a filled circle.}

\item{observed.pch}{Icon for the observed. Defaults to a diamond}

\item{contamination.pch}{Icon for the contamination. Defaults to a triangle.}

\item{true.name}{Name of the label of the true/target date}

\item{xlab}{Name of the x-axis. Defaults to 'contamination (\%)'.}

\item{ylab}{Name of the y-axis. Defaults to 'F14C'.}

\item{ylim}{Limits of the y-axis. Calculated automatically by default.}

\item{C14.axis}{Whether or not to draw a secondary vertical axis for C14 ages. Defaults to \code{C14.axis=TRUE}.}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="u"}.}
}
\value{
The true/target radiocarbon age and error
}
\description{
Given an observed radiocarbon age, remove the impact of contamination (for example, 1\% contamination with modern carbon) to estimate the true/target age
}
\details{
Whereas the function takes C14 ages and percentage contamination as input, internal calculations are done in the F14C realm and using fractions (between 0 and 1). The central calculation is `F_true = ((1-frac)*F_obs) - (frac*F_contam)`, where `F_true` is the true or target age in F14C, `frac` is the fraction of contamination, `F_obs` is the F14C of the observed C14 age, and `F_contam` is the F activity of the contamination. In some extreme cases, the calculations will spit out unexpected results. Messages will be provided in most of these cases.
}
\examples{
# 1\% contamination with modern carbon (no uncertainties in contamination's percentage or F)
clean(5000, 20, 1, 0, 1, 0)
# now with errors:
clean(5000, 20, 1, 0.1, 1, 0.1)
}
\author{
Maarten Blaauw
}
