% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct-sign.R
\name{correct_sign}
\alias{correct_sign}
\alias{corrected_value}
\alias{is_corrected}
\title{Corrects negative values in the health variable}
\usage{
correct_sign(x, shift = TRUE)

corrected_value(x)

is_corrected(x)
}
\arguments{
\item{x}{A numeric vector, typically representing health.}

\item{shift}{If \code{FALSE} (the default), 0 is imputed for all negative values in \code{x}. If \code{TRUE} the minimum value of \code{x} is subtracted from it.}
}
\value{
\code{correct_sign()} returns a list with 2 components:
\itemize{
\item{corrected}{corrected version of \code{x}}
\item{modified}{logical, \code{TRUE} when any of the elements of \code{x} have been changed}
\code{corrected_value()} returns the corrected value if passed the result of \code{correct_sign()}
\code{is_corrected()} returns \code{TRUE} if a modifications was made if passed the result of \code{correct_sign()}, \code{FALSE} otherwise
}
These components can be extracted with the functions \code{corrected_value} and \code{is_corrected}.
}
\description{
The Relative Concentration Index is not bonded between \eqn{[-1,1]} if the health variable contains both negative and positive values. This function corrects for this either by imputing a value of 0 for all negative values or by subtracting the minimum value.
}
\section{Functions}{
\itemize{
\item \code{corrected_value()}: Return the corrected value

\item \code{is_corrected()}: Check if the sign was corrected

}}
\examples{
data("housing")

# standardize & normalize bmi, will introduce negative values
housing$bmi.std <- (housing$bmi - mean(housing$bmi))/ sd(housing$bmi)

housing$bmi.std.shifted <- corrected_value(correct_sign(housing$bmi.std, shift = TRUE))
housing$bmi.std.imputed <- corrected_value(correct_sign(housing$bmi.std, shift = FALSE))

## compare the effect of both methods
plot(density(housing$bmi.std, na.rm = TRUE))
points(density(housing$bmi.std.shifted, na.rm = TRUE), col = 'blue')
points(density(housing$bmi.std.imputed, na.rm = TRUE), col = 'green')

}
\author{
Peter Konings
}
