% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackbox.R
\name{black_box_parts}
\alias{black_box_parts}
\title{Black Box Parts}
\usage{
black_box_parts(series, parts)
}
\arguments{
\item{series}{Matrix of the time series to black-box.}

\item{parts}{Vector giving the partitioning schema.}
}
\value{
Vector or Matrix giving the black-boxed time series.
}
\description{
Black-box time series from a collection of `l` sources where each series
has the same number of time steps but possibly different bases into a number
of different time series according to the partitioning scheme \code{parts}.
The resulting time series and their bases are returned. The base of the
resulting time series is given by the product of the bases of each time
series in the partition.
}
\examples{
# Black-box 4 time series in the same partition (1st) 
xs      <- matrix(0, nrow = 8, ncol = 4)
xs[, 1] <- c(0, 1, 1, 0, 1, 0, 0, 1)
xs[, 2] <- c(1, 0, 0, 1, 1, 0, 1, 0)
xs[, 3] <- c(0, 0, 0, 1, 1, 1, 0, 0)
xs[, 4] <- c(1, 0, 1, 0, 1, 1, 1, 0)
parts   <- c(1, 1, 1, 1)
black_box_parts(xs, parts)           # box = c(5 8 9 6 15 3 5 8), b = c(16)

# Black-box 4 time series with histories and futures:
# box[, 1] = c(1 2 3 0 3 1 1 2), the time series for the 1st partition
# box[, 1] = c(2 0 0 3 3 1 2 0), the time series for the 2st partition
# b = c(4, 4)
parts   <- c(1, 2, 2, 1)
black_box_parts(xs, parts)
}
