% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.R
\name{cubical}
\alias{cubical}
\title{Calculate Persistent Homology using a Cubical Complex}
\usage{
cubical(
  dataset,
  threshold = 9999,
  method = 0,
  standardize = FALSE,
  return_format = "df"
)
}
\arguments{
\item{dataset}{numeric array containing pixel/voxel data}

\item{threshold}{maximum diameter for computation of Cubical complex}

\item{method}{defaults to 0 for link join; alternatively, can be 1 for
compute pairs. See original Cubical Ripser code at GitHub user
CubicalRipser for details.}

\item{standardize}{boolean determining whether point cloud size should be standardized}

\item{return_format}{defaults to \code{"df"}, returning a data frame;
if \code{mat}, returns a numeric matrix}
}
\value{
3-column matrix with each row representing a TDA feature
}
\description{
Calculates the persistent homology of a 2- to 4-dimensional numeric array
using a Cubical complex. This function is an R wrapper for Takeki Sudo
and Kazushi Ahara's Cubical Ripser C++ library. For more information on
the C++ library, see \url{https://github.com/CubicalRipser}.
}
\examples{

# 2-dim example
dataset <- rnorm(10 ^ 2)
dim(dataset) <- rep(10, 2)
cubical_hom2 <- cubical(dataset)

# 3-dim example
dataset <- rnorm(8 ^ 3)
dim(dataset) <- rep(8, 3)
cubical_hom3 <- cubical(dataset)

# 4-dim example
dataset <- rnorm(5 ^ 4)
dim(dataset) <- rep(5, 4)
cubical_hom4 <- cubical(dataset)
}
