% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipums_info.r
\name{ipums_file_info}
\alias{ipums_file_info}
\title{Get IPUMS file information}
\usage{
ipums_file_info(object, type = NULL)
}
\arguments{
\item{object}{An ipums_ddi object (loaded with \code{\link{read_ipums_ddi}}).}

\item{type}{NULL to load all types, or one of "ipums_project", "extract_data",
"extract_notes", "conditions" or "citation".}
}
\value{
If \code{type} is NULL, a list with the \code{ipums_project},
  \code{extract_date}, \code{extract_notes}, \code{conditions}, and \code{citation}.
  Otherwise a string with the type of information requested in \code{type}.
}
\description{
Get IPUMS metadata information about the data file loaded into R
from an ipums_ddi
}
\examples{
ddi <- read_ipums_ddi(ripums_example("cps_00006.xml"))
ipums_file_info(ddi)
}
