% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.Score.R
\name{boxplot.Score}
\alias{boxplot.Score}
\title{Boxplot risk quantiles}
\usage{
\method{boxplot}{Score}(x, model, reference, type, timepoint, lwd = 3, xlim,
  xlab, main, outcomeLabel, eventLabels, refline = TRUE, ...)
}
\arguments{
\item{x}{Score object obtained by calling function \code{Score}.}

\item{model}{Choice of risk prediction model}

\item{reference}{Choice of reference risk prediction model for
calculation of risk differences.}

\item{type}{Either \code{"risk"} for predicted risks or
\code{"diff"} for differences between predicted risks.}

\item{timepoint}{time point specifying the prediction horizon}

\item{lwd}{line width}

\item{xlim}{x-axis limits}

\item{xlab}{x-axis label}

\item{main}{title of plot}

\item{outcomeLabel}{Title label for column which shows the outcome
status}

\item{eventLabels}{Labels for the different events (causes).}

\item{refline}{Logical, for \code{type="diff"} only. If \code{TRUE}
draw a red vertical line at \code{0}.}

\item{...}{not used}
}
\description{
Retrospective boxplots of risk quantiles conditional on outcome
}
\examples{
# binary outcome
db=sampleData(40,outcome="binary")
fitconv=glm(Y~X3+X5,data=db,family=binomial)
fitnew=glm(Y~X1+X3+X5+X6+X7,data=db,family=binomial)
scoreobj=Score(list(new=fitnew,conv=fitconv),
        formula=Y~1,contrasts=list(c(2,1)),
               data=db,summary="riskQuantile",nullModel=FALSE)
boxplot(scoreobj)

# survival outcome
library(survival)
ds=sampleData(40,outcome="survival")
fitconv=coxph(Surv(time,event)~X6,data=ds,x=TRUE,y=TRUE)
fitnew=coxph(Surv(time,event)~X6+X9,data=ds,x=TRUE,y=TRUE)
scoreobj=Score(list("conventional model"=fitconv,"new model"=fitnew),
                formula=Hist(time,event)~1, data=ds,
                summary="riskQuantile",metrics=NULL, plots=NULL,
                c(0,0.25,0.5,0.75,1),
                times=5,nullModel=FALSE)
boxplot(scoreobj)

scoreobj1=Score(list("conventional model"=fitconv,"new model"=fitnew),
                formula=Hist(time,event)~1, data=ds,
                summary="riskQuantile",metrics=NULL, plots=NULL,
                times=5,nullModel=FALSE,compare=list(c(2,1)))
boxplot(scoreobj1)

# competing risks outcome
\dontrun{
data(Melanoma)
fitconv = CSC(Hist(time,status)~invasion+age+sex,data=Melanoma)
fitnew = CSC(Hist(time,status)~invasion+age+sex+logthick,data=Melanoma)
scoreobj=Score(list("Conventional model"=fitconv,"New model"=fitnew),
               formula=Hist(time,status)~1,
               data=Melanoma,metrics=NULL,summary="riskQuantile",times=5*365.25,nullModel=FALSE)
boxplot(scoreobj)
}

# more than 2 competing risks
m=lava::lvm(~X1+X2+X3)
lava::distribution(m, "eventtime1") <- lava::coxWeibull.lvm(scale = 1/100)
lava::distribution(m, "eventtime2") <- lava::coxWeibull.lvm(scale = 1/100)
lava::distribution(m, "eventtime3") <- lava::coxWeibull.lvm(scale = 1/100)
lava::distribution(m, "censtime") <- lava::coxWeibull.lvm(scale = 1/100)
lava::regression(m,eventtime2~X3)=1.3
m <- lava::eventTime(m,
time ~ min(eventtime1 = 1, eventtime2 = 2, eventtime3 = 3, censtime = 0), "event")
set.seed(101)
dcr=as.data.table(lava::sim(m,101))
fitOld = CSC(Hist(time,event)~X1+X2,data=dcr)
fitNew = CSC(Hist(time,event)~X1+X2+X3,data=dcr)
scoreobj=Score(list("Conventional model"=fitOld,"New model"=fitNew),
               formula=Hist(time,event)~1,
               data=dcr,summary="riskQuantile",times=5,nullModel=FALSE)
boxplot(scoreobj)


}

