% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_reverse_dependencies.R
\name{metric_score.pkg_metric_reverse_dependencies}
\alias{metric_score.pkg_metric_reverse_dependencies}
\title{Scoring method for number of reverse dependencies a package has}
\usage{
\method{metric_score}{pkg_metric_reverse_dependencies}(x, ...)
}
\arguments{
\item{x}{a \code{pkg_metric_reverse_dependencies} packge metric object}

\item{...}{additional arguments unused}
}
\value{
numeric value between \code{1} (high number of reverse dependencies) and
  \code{0} (low number of reverse dependencies)
}
\description{
Score a package for the number of reverse dependencies it has; regularized
Convert the number of reverse dependencies \code{length(x)} into a validation
score [0,1] \deqn{ 1 / (1 + exp(-0.5 * (sqrt(length(x)) + sqrt(5)))) }
}
\details{
The scoring function is the classic logistic curve \deqn{
1 / (1 + exp(-k(x-x[0])) } with a square root scale for the number of reverse dependencies
\eqn{x = sqrt(length(x))}, sigmoid midpoint is 5 reverse dependencies, ie. \eqn{x[0] =
sqrt(5)}, and logistic growth rate of \eqn{k = 0.5}.

\deqn{ 1 / (1 + -0.5 * exp(sqrt(length(x)) - sqrt(5))) }
}
\examples{
\dontrun{metric_score(assess_reverse_dependencies(pkg_ref("riskmetric")))
}
}
