% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_valid_prob_set}
\alias{is_valid_prob_set}
\title{Verify that a set of probability inputs is valid.}
\usage{
is_valid_prob_set(prev, sens = NA, mirt = NA, spec = NA, fart = NA, tol = 0.01)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{tol}{A numeric tolerance value used by \code{\link{is_complement}}.}
}
\value{
A Boolean value:
\code{TRUE} if the probabilities provided are valid;
otherwise \code{FALSE}.
}
\description{
\code{is_valid_prob_set} is a function that verifies that
a set of (3 to 5) numeric inputs can be interpreted as a
valid set of (3 essential and 2 optional) probabilities.
}
\details{
\code{is_valid_prob_set} is a wrapper function that combines
\code{\link{is_prob}}, \code{\link{is_suff_prob_set}},
and \code{\link{is_complement}} in one function.

While no alternative input option for frequencies is provided,
specification of the essential probability \code{\link{prev}}
is always necessary. However, for 2 other essential
probabilities there is a choice:

\enumerate{
  \item Either \code{\link{sens}} or \code{\link{mirt}} is necessary
        (as both are complements).

  \item Either \code{\link{spec}} or \code{\link{fart}} is necessary
       (as both are complements).
}

The argument \code{tol} is optional (with a default value of .01)
and used as the tolerance value of \code{\link{is_complement}}.

\code{is_valid_prob_set} verifies the validity of inputs,
but does not compute or return numeric variables.
Use \code{\link{is_extreme_prob_set}} to verify sets of probabilities
that describe extreme cases and \code{\link{init_num}}
for initializing basic parameters.
}
\examples{
# ways to succeed:
is_valid_prob_set(1, 1, 0, 1, 0)                 # => TRUE
is_valid_prob_set(.3, .9, .1, .8, .2)            # => TRUE
is_valid_prob_set(.3, .9, .1, .8, NA)            # => TRUE + warning (NA)
is_valid_prob_set(.3, .9, NA, .8, NA)            # => TRUE + warning (NAs)
is_valid_prob_set(.3, .9, NA, NA, .8)            # => TRUE + warning (NAs)
is_valid_prob_set(.3, .8, .1, .7, .2, tol = .1)  # => TRUE (due to increased tol)

# watch out for:
is_valid_prob_set(1, 0, 1, 0, 1)    # => TRUE, but NO warning about extreme case!
is_valid_prob_set(1, 1, 0, 1, 0)    # => TRUE, but NO warning about extreme case!
is_valid_prob_set(1, 1, 0, 1, NA)   # => TRUE, but NO warning about extreme case!
is_valid_prob_set(1, 1, 0, NA, 1)   # => TRUE, but NO warning about extreme case!
is_valid_prob_set(1, 1, 0, NA, 0)   # => TRUE, but NO warning about extreme case!

# ways to fail:
is_valid_prob_set(8, 1, 0, 1, 0)      # => FALSE + warning (is_prob fails)
is_valid_prob_set(1, 1, 8, 1, 0)      # => FALSE + warning (is_prob fails)
is_valid_prob_set(2, 1, 3, 1, 4)      # => FALSE + warning (is_prob fails)
is_valid_prob_set(1, .8, .2, .7, .2)  # => FALSE + warning (beyond complement range)
is_valid_prob_set(1, .8, .3, .7, .3)  # => FALSE + warning (beyond complement range)
is_valid_prob_set(1, 1, 1, 1, 1)      # => FALSE + warning (beyond complement range)
is_valid_prob_set(1, 1, 0, 1, 1)      # => FALSE + warning (beyond complement range)

}
\seealso{
\code{\link{is_valid_prob_pair}} verifies that probability pairs are complements;
\code{\link{is_prob}} verifies probabilities;
\code{\link{prob}} contains current probability information;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{as_pc}} displays a probability as a percentage;
\code{\link{as_pb}} displays a percentage as probability.

Other verification functions: 
\code{\link{is_complement}()},
\code{\link{is_extreme_prob_set}()},
\code{\link{is_freq}()},
\code{\link{is_integer}()},
\code{\link{is_matrix}()},
\code{\link{is_perc}()},
\code{\link{is_prob}()},
\code{\link{is_suff_prob_set}()},
\code{\link{is_valid_prob_pair}()},
\code{\link{is_valid_prob_triple}()}
}
\concept{verification functions}
